<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\Experiencia;
use App\Models\Place;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AdminBusquedasController extends Controller
{
    public function busquedaUsuarios(Request $request)
    {

        if(Auth::user()->role_id != 1)return redirect('/');
        switch ($request->criterio_busqueda) {
            //Usuarios
            case 1:
                return view('admin.busqueda.users',['users'=>User::where('name','LIKE',"%{$request->busqueda}%")->paginate(10)]);
            //Experiencias
            case 2:
                return view('admin.busqueda.busqueda-dinamica',['experiencias'=>Experiencia::where('title','LIKE',"%{$request->busqueda}%")->paginate(10),'response'=>2]);
                break;
            //Categorias
            case 3:
                return view('admin.busqueda.busqueda-dinamica',['categorias'=>Category::where('title','LIKE',"%{$request->busqueda}%")->paginate(10),'response'=>3]);
                break;
            //Ventas
            // case 4:
            //     return view('admin.busqueda.busqueda-dinamica',['experiencias'=>Experiencia::where('title','LIKE',"%{$request->busqueda}%")->paginate(10),'response'=>4]);
            //     break;

            //Lugares
            case 5:
                return view('admin.busqueda.busqueda-dinamica',['lugares'=>Place::where('name','LIKE',"%{$request->busqueda}%")->paginate(10),'response'=>5]);
                break;
            //Usuarios
            default:
                return view('admin.busqueda.users',['users'=>User::where('name','LIKE',"%{$request->busqueda}%")->paginate(10)]);
            break;
        }
    }

    public function buscarAnfitrion(Request $request)
    {
        return view('admin.usuario.anfitriones-busqueda',[
            'users'=>User::where('name','LIKE',"%{$request->searched}%")
                ->orWhereHas('UsersDetail', function ($query) use ($request) {
                    $query->where('fake_name','LIKE',"%{$request->searched}%");
                })
                ->paginate(10),
        ]);
    }
}
