<?php

namespace App\Console\Commands;

use App\Models\User;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Hash;

class CreateUser extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'users:create_user {name} {email} {password}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Creates a new User from the console';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $name = $this->argument('name');
        $email = $this->argument('email');
        $password = Hash::make($this->argument('password'));

        if ($this->confirm('This will create a new user , wtih email: "'.$email.'" with the password you provide , do you want to continue ,"'.$name.'" ?')) {
            User::create([
                'name' =>$name,
                'email'=>$email,
                'password'=>$password,
                'gender'=>'Hombre',
                'city'=>'CABA',
                'province'=>'Buenos Aires',
                'country'=>'Argentina',
                'phone'=>'11-111-1111',
                'picture'=>'admin.png',
                'role_id'=>3, //anfitrion:3, Admin:1, Cliente:2.
                'state'=>0,
            ]);
        }

        $this->info('User successfully created with Email: '.$email.", and password gived");

    }
}
