const express = require("express");
const apiControllers = require("../controllers/ApiController");
const router = express.Router();

router
  .route("/contact")
  .get(apiControllers.getContacts);

router
  .route("/contact/:id")
  .get(apiControllers.getContactById);

router
  .route("/contact")
  .post(apiControllers.createNewContact);

router
  .route("/contact/:id")
  .delete(apiControllers.deleteContact);

router
  .route("/newsletter")
  .get(apiControllers.getNewsletters);

router
  .route("/newsletter/:id")
  .get(apiControllers.getNewsletterById);

router
  .route("/newsletter")
  .post(apiControllers.createNewsLetter);

router
  .route("/newsletter/:id")
  .delete(apiControllers.deleteNewsLetter);

router
  .route("/user")
  .post(apiControllers.createUser);

router
  .route("/login")
  .post(apiControllers.login);

  router
  .route("/logout")
  .get(apiControllers.logout);

  router
  .route("/createPaswordEndpoint")
  .post(apiControllers.createPaswordEndpoint);

module.exports = router;
