var table;

$(document).ready(function () {
  setTableWithNewsletters();
});

function setTableWithNewsletters() {
  table = $('#html_table_newsletter').DataTable({
    "processing": true,
    "serverSide": true,
    "scrollX": true,
    "responsive": true,
    "language": {
      "loadingRecords": "&nbsp;",
      "processing": '<div class="m-loader m-loader--lg m-loader--warning"></div>'
    },
    "ajax": "/api/v1/newsletter",
    "columns": [
      { "data": "email", type: "readonly" },
      {
        "data": "_id",
        "render": function (data, type, row) {
          return `<button class="  btn-danger " id="${row._id}" onclick="askDeleteNewsletter('${row._id}')">Delete</button>`;
        }
      }
    ],
  });
}

function askDeleteNewsletter(id) {
  Swal.fire({
    title: "Eliminar newsletter",
    text: "desea eliminar este Newsletter?",
    icon: "warning",
    confirmButtonText: `si`,
    showCancelButton: !0,
    cancelButtonText: "Cancelar",
  })

  $('.swal2-confirm').attr('id', 'btnConfirm')
  var el = document.getElementById("btnConfirm");
  el.addEventListener("click", function () { deleteNewsletter(id) });
}

function deleteNewsletter(id) {
  $.ajax({
    url: "/api/v1/newsletter/" + id,
    method: "delete",
    success: function (data) {
      $('#html_table_newsletter').DataTable().ajax.reload();
    },
    error: function (error) {
      console.log(error);
    }
  });
}

