var table;

$(document).ready(function () {
  setTableWithContacts();

  $('#seeContactModal').on('shown.bs.modal', function (e) {
    let name = $(e.relatedTarget).data('name');
    let email = $(e.relatedTarget).data('email');
    let message = $(e.relatedTarget).data('message');
    let phone = $(e.relatedTarget).data('phone');
    let company = $(e.relatedTarget).data('company');

    document.getElementById("contact_email").innerHTML = 'Email: ' + email;
    document.getElementById("contact_name").innerHTML = 'Name: ' + name;
    document.getElementById("contact_phone").innerHTML = 'Phone: ' + phone;
    document.getElementById("contact_company").innerHTML = 'Company: ' + company;
    document.getElementById("contact_message").innerHTML = 'Message: ' + message;
  })
});

function setTableWithContacts() {
  table = $('#html_table_contacts').DataTable({
    "processing": true,
    "serverSide": true,
    "scrollX": true,
    "responsive": true,
    "select": 'single',
    "language": {
      "loadingRecords": "&nbsp;",
      "processing": '<div class="m-loader m-loader--lg m-loader--warning"></div>'
    },
    "ajax": "/api/v1/contact",
    "columns": [
      { "data": "email", type: "readonly" },
      { "data": "name" },
      { "data": "company" },
      { "data": "phone" },
      {
        "data": "_id",
        "render": function (data, type, row) {
          return `
          <button class="btn-primary " data-toggle="modal" data-target="#seeContactModal" 
          data-name="${row.name}"
          data-email="${row.email}"
          data-company="${row.company}"
          data-message="${row.message}"
          data-phone="${row.phone}"
          > Ver </button>
          <button class="  btn-danger " id="${row._id}" onclick="askDeleteContact('${row._id}')">Delete</button>
          `;
        }
      }
    ],
  });
}

function askDeleteContact(id) {
  Swal.fire({
    title: "Eliminar contacto",
    text: "desea eliminar este contacto?",
    icon: "warning",
    confirmButtonText: `si`,
    showCancelButton: !0,
    cancelButtonText: "Cancelar",
  })

  $('.swal2-confirm').attr('id', 'btnConfirm')
  var el = document.getElementById("btnConfirm");
  el.addEventListener("click", function () { deleteContact(id) });
}

function deleteContact(id) {
  $.ajax({
    url: "/api/v1/contact/" + id,
    method: "delete",
    success: function (data) {
      $('#html_table_contacts').DataTable().ajax.reload();
    },
    error: function (error) {
      console.log(error);
    }
  });
}

