const nodemailer = require("nodemailer");
require('dotenv').config();
var ejs = require("ejs")

async function sendContactMail(contact) {

    let transporter = nodemailer.createTransport({
        host: "smtp.gmail.com",
        port: process.env.EMAIL_PORT,
        secure: true,
        auth: {
            type: "OAuth2",
            user: process.env.EMAIL_ADDRESS,
            clientId: process.env.EMAIL_CLIENT_TOKEN,
            clientSecret: process.env.EMAIL_SECRET_TOKEN,
            refreshToken: process.env.EMAIL_REFRESH_TOKEN,
        },
        tls: {
            rejectUnauthorized: false
        }
    });

    ejs.renderFile(__dirname + "/emails/email.ejs", { name: contact.name, email: contact.email, company: contact.company, phone: contact.phone, message: contact.message,}, async function (err, data) {
        if (err) {
            console.log(err);
        } else {
            let info = await transporter.sendMail({
                from: process.env.EMAIL_ADDRESS,
                to: process.env.EMAIL_TO_DESTINY,
                subject: "New contact from Epica" + contact.name + ")",
                text: "New contact from Epica" + contact.name + ")",
                html: data,
            });
        
        }
    });

}
async function sendNewsletterMail(email) {

    let transporter = nodemailer.createTransport({
        host: "smtp.gmail.com",
        port: process.env.EMAIL_PORT,
        secure: true,
        auth: {
            type: "OAuth2",
            user: process.env.EMAIL_ADDRESS,
            clientId: process.env.EMAIL_CLIENT_TOKEN,
            clientSecret: process.env.EMAIL_SECRET_TOKEN,
            refreshToken: process.env.EMAIL_REFRESH_TOKEN,
        },
        tls: {
            rejectUnauthorized: false
        }
    });

    let info = await transporter.sendMail({
        from: process.env.EMAIL_ADDRESS,
        to: process.env.EMAIL_TO_DESTINY,
        subject: "Nuevo newsletter de Epica",
        text: "Nuevo newsLetter de epica ",
        html: "<p>Email: "+ email+"</p>",
    });
}

module.exports = { sendContactMail , sendNewsletterMail};
