import { useRef, useState, useEffect } from 'react';
import { Helmet } from 'react-helmet-async';
import { useSelector, useDispatch } from 'react-redux';
import gsap from 'gsap';
import { ScrollTrigger } from 'gsap/ScrollTrigger';
import { changeState } from '../../store/actions';
import { Container, Logo } from '../../components';
import { timeLine } from './animations';
import './styles.scss';

gsap.registerPlugin(ScrollTrigger);

const PrivacyPolicy = () => {
  const [animationComplete, setAnimationComplete] = useState(false);
  const contentRef = useRef(null);
  const svgPathRef = useRef(null);
  const svgWrapperRef = useRef(null);
  const scrollBarRef = useRef(null);
  const tl = useRef(null);
  const dispatch = useDispatch();
  const { isMainContentLoaded } = useSelector((state) => state.reducers);

  useEffect(() => {
    tl.current = timeLine(svgPathRef, svgWrapperRef, contentRef, () => {
      setAnimationComplete(true);
    });
    const scrollBar = scrollBarRef.current;
    gsap.to(scrollBar, { scaleX: 1, scrollTrigger: { scrub: true } });
  }, []);

  useEffect(() => {
    !isMainContentLoaded && dispatch(changeState('isMainContentLoaded', true));
  }, []);

  useEffect(() => {
    const { documentElement: html } = document;
    animationComplete && (html.style.overflowY = /Firefox/.test(navigator.userAgent) ? 'auto' : 'overlay');
  }, [animationComplete]);

  return (
    <>
      <Helmet>
        <title>Epica's Global Privacy Policy | Epica Creative Agency</title>
        <meta
          name='description'
          content="This Privacy Policy describes Epica's commitment to protecting your privacy. Is regularly reviewed and is updated as often as necessary by Epica."
          data-rh='true'
        />
      </Helmet>
      <main className='privacyMain'>
        <div className='privacyScrollbar' ref={scrollBarRef} />
        {!animationComplete && (
          <div className='privacySVGWrapper' ref={svgWrapperRef}>
            <svg viewBox='0 0 1000 1000' preserveAspectRatio='none' className='privacySVG'>
              <path ref={svgPathRef} d='M0,1005S175,995,500,995s500,5,500,5V0H0Z'></path>
            </svg>
          </div>
        )}
        <Container>
          <div className='privacyPolicy' ref={contentRef}>
            <div className='privacyLogo'>
              <Logo animated href='/' />
            </div>
            <h1 className='privacyTitle'>Epica´s Global privacy Policy</h1>
            <p className='privacyText'>
              Date Posted: January 9th, 2023 <br />
              Epica Inc., its subsidiaries, and affiliates (collectively “Epica,” “we,” “us,” or “our”) have adopted
              this privacy policy (“Privacy Policy”) in connection with the use of our cloud services (the “Cloud
              Services”) by our customers (“Customers,” “you,” or “your”) and other users that are authorized by Epica
              to access and use the Cloud Services (“Users”). Epica understands that Customers, potential Customers, and
              other Users that visit our website (“the Website”) and/or use the Cloud Services care about how their
              information is collected, used, processed, transferred, stored, and shared. This Privacy Policy describes
              Epica’s commitment to protecting your privacy. Any capitalized terms not defined in this Privacy Policy
              shall carry the meanings set forth for such terms in Epica’s Cloud Services Agreement and/or Epica’s
              Acceptable Use Policy. Please familiarize yourself with this Privacy Policy. This Privacy Policy is
              regularly reviewed and is updated as often as necessary by Epica. Any such updates will be posted publicly
              on the Website. If we make substantive changes to the purposes and policies set forth in this Privacy
              Policy, we will update this page and we will inform Customers of any such update via email or through
              notifications within the Cloud Services.
            </p>
            <h2 className='privacySubtitle'>1. The Information We Collect and How We Use It</h2>

            <div>
              <h3 className='privacythirdTitle'>1.1 Website</h3>
              <p className='privacyText'>
                When you visit our Website, you are not required to actively provide any information. However, we may
                collect some of your Personal Data and Navigation Information (each as defined in Section 1.3 below). We
                collect some Personal Data, and may collect some Navigation Information, when you contact us via the
                Website, sign up to download or receive information from us, or sign up to use our Cloud Services. Some
                information is collected via the Website using cookies. See Section 4, below.
              </p>
            </div>

            <div>
              <h3 className='privacythirdTitle'>1.2 Epica’s Cloud Services</h3>
              <p className='privacyText'>
                We may collect Personal Data and Navigation Information from Customers and Users of our Cloud Services
                to help us provide, administer, and improve the Cloud Services and your use of the same. In order to use
                the Cloud Services, you will need to provide your full name and email address to us as well as any other
                information, as set forth in this Privacy Policy, which information is necessary for Epica’s fulfillment
                of its obligations to you under the relevant Epica Cloud Services Agreement.
              </p>
            </div>

            <div>
              <h3 className='privacythirdTitle'>1.3 Collected Data</h3>
              <p className='privacyText'>
                “Personal Data” refers to any information that can be used to identify you personally. For our purposes,
                this may include your (first and last) name, email address, User ID, company name, address, phone
                number, data you write in a contact form, your project role, your uploads (including any creatives
                and/or content related to any of your advertisements that are served through the Cloud Services), your
                preferences, and your account information and settings. “Navigation Information” refers to information
                about your computer, device, visits to the Website, and use of the Cloud Services. For our purposes,
                this may include the website you visited prior to visiting our Website or the link or campaign you
                clicked on to reach our website, your IP address, geographical location (city and/or country), browser
                type and version, internet service provider information, referral sources, length of visits, pages
                viewed, language preferences, heat mapping, and other forms of website analysis. In some cases,
                Navigation Information may also be Personal Data. Generally, we may use your Personal Data and
                Navigation Information for the following purposes:
              </p>
            </div>

            <p className='privacyText'>
              <span className='pht'>1.3.1</span> Personalizing the Website for the legitimate purpose of improving your
              experience and use of the Cloud Services. We retain Personal Data processed for this purpose until your
              browsing session with us has ended or until such time as you no longer have a profile or account with
              Epica;
              <br />
              <span className='pht'>1.3.2</span> Creating and/or managing your Epica account in performance of our
              Agreement (as defined in Epica’s Cloud Services Agreement). We retain Personal Data processed for this
              purpose until we receive an actionable request to delete a Customer’s (or User’s) Personal Data, or in the
              case of termination or expiration of our Agreement with a Customer, as applicable;
              <br />
              <span className='pht'>1.3.3</span> Understanding Customer and User preferences for the legitimate purpose
              of improving the Cloud Services. We may retain Personal Data processed for this purpose until you withdraw
              your consent;
              <br />
              <span className='pht'>1.3.4</span> Interlinking Customer and User information to learn about your
              preferences and those of Customers and Users like you for the legitimate purpose of improving our
              services. We may retain Personal Data processed for this purpose until you withdraw your consent; and
              <br />
              <span className='pht'>1.3.5</span> Contacting you for direct marketing purposes. We may retain Personal
              Data processed for this purpose until you withdraw your consent.
              <br />
              <span className='pht'>1.4</span> Supporting Suppliers <br />
              The Website and the Cloud Services integrate some services and/or products provided by third parties. We
              may share some of your information with these suppliers so that they can provide their services and/or
              products to you (including the serving of advertisements on media, payment processing, removing repetitive
              information from prospect lists, analyzing data, marketing support, Customer and/or User profiling,
              business development, and customer service), thereby facilitating your use of the Cloud Services. To
              ensure that your Personal Data is collected, processed, used, stored, and transferred securely and in
              accordance with applicable law, Epica uses third parties that provide sufficient guarantees to implement
              appropriate technical and organizational measures to protect your information. For such third parties that
              may transfer Personal Data outside the European Economic Area, Epica implements appropriate safeguards for
              such transfers (e.g., EU Standard Contractual Clauses, and binding corporate rules). Please note, the
              terms and privacy policies of such third parties may apply to you as well, in particular: Google
              Analytics, Stripe. Your acceptance of applicable third party terms and policies is required to access the
              Website and the Cloud Services. Disclaimer: This overview of third-party suppliers provides a current view
              of their policies. Epica strives to keep this list as up to date as reasonably possible.
              <br />
            </p>

            <div>
              <h3 className='privacythirdTitle'>1.5 Third-Party Websites</h3>
              <p className='privacyText'>
                The Website and/or the Cloud Services may contain links to third party websites. Such links do not
                amount to an endorsement of such other websites by Epica, and Epica is not responsible for any websites
                other than its Website.
              </p>
            </div>

            <div>
              <h3 className='privacythirdTitle'>1.6 Customer Testimonials</h3>
              <p className='privacyText'>
                We may publish Customer testimonials on the Website or in other marketing materials which may contain
                Personal Data. We will obtain consent from each relevant Customer and any featured individuals prior to
                publishing any testimonials. This consent may be thereafter withdrawn by communicating your desire to
                withdraw such consent via email to{' '}
                <a href='mailto:legal@epicamedia.com' className='privacyLink'>
                  legal@epicamedia.com
                </a>
              </p>
            </div>

            <div>
              <h3 className='privacythirdTitle'>1.7 Information of Children</h3>
              <p className='privacyText'>
                The Website and Cloud Services are for business use and are not intended for or targeted toward children
                under 18 years of age (“Children”). We do not knowingly collect any information about Children. We
                encourage parents and legal guardians to monitor the internet usage of their Children and ensure they do
                not use the Cloud Services or provide personal information to Epica. If you believe that we have
                collected information about Children, please contact us at{' '}
                <a href='mailto:legal@epicamedia.com' className='privacyLink'>
                  legal@epicamedia.com
                </a>{' '}
                so that we can delete that information.
              </p>
            </div>

            <div>
              <h3 className='privacythirdTitle'>1.8 We Do Not Sell Personal Data</h3>
              <p className='privacyText'>We do not sell your Personal Data.</p>
            </div>

            <h2 className='privacySubtitle'>2.Personal Data Retention and Security </h2>

            <div>
              <h3 className='privacythirdTitle'>2.1. Retention of Personal Data</h3>
              <p className='privacyText'>
                We retain Personal Data for as long as we reasonably consider it necessary for the purposes for which it
                was collected, after which time we will delete such information. You can request deletion of your
                Personal Data as described in Section 3 below.
              </p>
            </div>

            <div>
              <h3 className='privacythirdTitle'>2.2. Security of Personal Data</h3>
              <p className='privacyText'>
                Data security is a matter of critical importance to us. Epica uses a wide range of security measures to
                safeguard your data against unauthorized access and disclosure, and we continually assess our security
                systems to ensure their effectiveness. Amazon Web Services, Cloudflare and Elastic Cloud provide our
                servers and maintains them in high-security controlled environments pursuant to the their cloud security
                policies.
              </p>
            </div>

            <div>
              <h3 className='privacythirdTitle'>2.3. Transfer of Personal Data</h3>
              <p className='privacyText'>
                As a business that has Customers and Users worldwide, we may transfer and access Personal Data around
                the world, including to and from the United States. To comply with applicable law, we maintain strong
                data protection and privacy controls to protect your Personal Data during cross-border and international
                transfers, as well as during periods of storage in foreign countries. <br />
                We believe that your privacy rights are not contingent on your nationality or residency. While
                applicable law always governs data privacy matters, we intend for this Privacy Policy to apply generally
                to Customers, Users, and their Personal Data around the world. Nevertheless, privacy law is constantly
                changing so we reserve the right to deviate from (and to revise) this Privacy Policy where applicable
                law provides for different requirements.
              </p>
            </div>

            <div>
              <h3 className='privacythirdTitle'>2.4. Required Disclosure of Personal Data</h3>
              <p className='privacyText'>
                We may use or disclose your Personal Data if we reasonably determine that such use or disclosure is
                necessary to (a) protect our rights, operations, Customers, or Users; (b) comply with applicable laws, a
                valid court order, or other legal proceeding; and/or (c) otherwise perform the contractual obligations
                we have regarding our Customers. <br />
                We may transfer the data we control, including Personal Data, in the event of a company reorganization,
                merger, or sale.
              </p>
            </div>

            <h2 className='privacySubtitle'>3.Your Data and Your Rights</h2>
            <div className='privacyText'>
              As a general matter, depending on local data protection laws, you have rights that may include:
              <ul>
                <li className='privacyListItem'>
                  Obtaining clear information on our processing of your Personal Data; 
                </li>
                <li className='privacyListItem'>
                  Accessing your Personal Data that we hold, together with the right to have inaccuracies corrected;
                </li>
                <li className='privacyListItem'>
                  Having your Personal Data delivered to you in a standard electronic format;
                </li>
                <li className='privacyListItem'>
                  Objecting to our processing of your Personal Data, and preventing solely automated decision making or
                  profiling; and
                </li>
                <li className='privacyListItem'>
                  Restricting our processing of your Personal Data, or having your Personal Data deleted.
                </li>
              </ul>
            </div>

            <div>
              <h3 className='privacythirdTitle'>3.1 How to Exercise Your Rights</h3>
              <p className='privacyText'>
                If you wish to exercise your rights with respect to your Personal Data, you can email your request to
                <a href='mailto:hello@uosolutions.com' className='privacyLink'>
                  hello@uosolutions.com
                </a>{' '}
                or send postal mail to us at: <br />
                Name: Epica LLC. <br />
                Address: One Flagler Building, 14 NE 1st Ave Ste 307, Miami, FL 33132-2404, USA Attn: Legal Department{' '}
                <br />
                We will generally respond to your request within 30 days. <br />
                If you wish to unsubscribe from an email list, please click the “unsubscribe” link found at the bottom
                of our emails. If you work for one of Epica’s Customers, you should request from such Customer that such
                Customer delete your Personal Data. If you want to raise a complaint about the way we process your
                Personal Data or the way we have handled a request, please contact us by email or postal mail as set
                forth in this section, above. <br />
                Customers and other Users of Epica’s Cloud Services can withdraw any consent they provided by adjusting
                their profile settings through the Cloud Services or by communicating with us via email or postal mail
                as set forth in this section, above. <br />
                Please note that the collection, processing, use, sharing, storage, and transfer of your Personal Data
                may be necessary for you to be able to use our Cloud Services, and that Epica’s Customers and Users
                cannot unsubscribe from emails we consider to be important in connection with your use of the Cloud
                Services.
              </p>
            </div>

            <h2 className='privacySubtitle'>4.Cookies </h2>

            <p className='privacyText'>
              We use cookies on our Website. Cookies are small text files sent by a web server to your web browser and
              saved locally on your computer or device. The cookies allow the server to uniquely identify the browser on
              each page. Cookies do not cause any harm to your computer or device, and do not contain any viruses.{' '}
              <br />
              We use the following categories of cookies on our website:
            </p>

            <p className='privacyText'>
              <span className='pht'>Category A:</span> Strictly Necessary Cookies <br />
              Strictly necessary cookies are essential in order to enable you to navigate the Website and use the Cloud
              Services. Without these cookies, we would be unable to provide you with the Cloud Services.
              <br />
              <span className='pht'>Category B:</span> Functionality Cookies <br />
              Performance cookies collect information on how Customers and other Users use our Website. The data stored
              by these cookies never shows personal details from which your individual identity can be established.
              <br />
              <span className='pht'>Category C:</span> UFunctionality Cookies <br />
              Functionality cookies remember choices you make such as the country you visit our Website from, the
              applicable language and search parameters. These can then be used to provide you with an experience more
              appropriate to your selections and to make the use of Cloud Services more tailored to your goals and
              objectives. <br />
              Disabling and Opting-Out of Cookies <br />
              Current versions of web browsers offer enhanced user controls regarding the placement and duration of both
              first and third party cookies. Search for "cookies" under your web browser's Help menu for more
              information on cookie management features available to you. You can enable or disable cookies by modifying
              the settings in your browser. However, if you choose to disable cookies in your browser, you may be unable
              to complete certain activities on our Website or to correctly access or use certain aspects of the Cloud
              Services. <br />
              Information Collected from Other Websites and Do Not Track Policy
              <br />
              <br />
              Through the cookies we place on your browser or device, we may collect information about your online
              activity after you leave our website. Just like any other usage information we collect, this information
              allows us to improve the services and customize your online experience, and otherwise as described in this
              Privacy Policy. Your browser may offer you a “Do Not Track” option, which allows you to signal to
              operators of websites and web applications and services (including behavioral advertising services) that
              you do not wish such operators to track certain of your online activities over time and across different
              websites. Our Cloud Services do not support Do Not Track requests at this time, which means that we
              collect information about your online activity both while you are using the services and after you leave
              our services.
            </p>

            <h2 className='privacySubtitle'>5. California Consumer Privacy Act (CCPA) Supplement</h2>

            <p className='privacyText'>
              The CCPA is effective as of January 1, 2020. If you are a resident of California, this supplement to the
              Privacy Policy (this Section 5 of the Privacy Policy) sets forth additional rights and information that is
              relevant to you. A number of requirements under the CCPA are addressed in other provisions of this Privacy
              Policy. This supplemental section is meant to fill in any gaps for California residents of provisions that
              have not already been set forth in this Privacy Policy, above. The terms used in this supplemental section
              are either defined in this Privacy Policy or in the text of the CCPA. CCPA Consumer Rights Under the CCPA,
              you have, among others, the following rights: The right to know and to access the categories of personal
              information and the specific personal information we collect in connection with your use of the Cloud
              Services; The right to have your personal information we collect deleted, subject to certain legal
              limitations; The right to request disclosure of your personal information that we collected; and The right
              to disclosure of your information that we disclosed for valuable consideration. Submitting Requests under
              CCPA California residents may submit requests to Epica for information permitted under the CCPA via email
              to{' '}
              <a href='mailto:legal@epicamedia.com' className='privacyLink'>
                legal@epicamedia.com
              </a>
              . Please be as specific as possible when you exercise your rights under CCPA and submit a request to us
              regarding your personal information. In addition, please note that, under the CCPA, we are obligated to
              verify your identify before we process your request. No Discrimination Epica will not discriminate against
              you in pricing, user experience, or any other way for exercising any of your rights under the CCPA.
            </p>

            <h2 className='privacySubtitle'>6. General Data Protection Regulation (GDPR) Supplement</h2>

            <p className='privacyText'>
              The European Union’s (EU) General Data Protection Regulation, better known as GDPR, is one of the most
              comprehensive privacy and security laws in the world, and is effective as of May 25, 2018. This regulation
              was implemented by the EU to harmonize data privacy laws across Europe, protect EU citizens’ data privacy,
              give individuals more control over their Personal Data, and regulate the way organizations approach data
              privacy. At Epica, we have worked hard to become GDPR compliant. Because of the importance of GDPR
              regulations for our Customers, partners, and other relevant stakeholders, this section aims at promoting
              transparency and understanding in connection with how Epica approaches GDPR compliance. <br />
              GDPR’s Application <br />
              GDPR applies to any entity or company that processes Personal Data as part of business activities within
              the EU, and to organizations that are not established in the EU but still offer products/services and/or
              is monitoring the behavior of individuals within the EU. <br />
              GDPR outside of the EU <br /> GDPR allows Personal Data to be processed outside of the EU when specific
              arrangements are made to ensure an adequate level of data protection. Epica has data processing agreements
              in place with its relevant processors and controllers to ensure the security of Personal Data in
              accordance with the requirements of the GDPR. Under the GDPR, businesses to which the GDPR applies must
              adhere to the following rules: Personal Data must be processed in a lawful and transparent manner; there
              must be specific purposes for processing the data and those purposes must be indicated to individuals when
              collecting their Personal Data only the personal data that is necessary to fulfil a purpose can be
              collected; Personal Data cannot be stored longer than necessary for the purposes for which it was
              collected; and organizations must install appropriate technical and organizational safeguards that ensure
              the security of the Personal Data. <br />
              Our Compliance with the GDPR <br />
              Epica collects, uses, processes, transfers, and stores Personal Data in connection with the provision of
              our Cloud Services to Customers and Users, contracting with third-party suppliers, or hiring new
              employees. Epica identifies all the Personal Data that is processed and defines the purpose of this
              processing in order to determine how the collected data is used and provide appropriate visibility and
              transparency. Epica is developing systems and procedures to implement GDPR principles into our system,
              data, and business practices on an ongoing basis. Additionally, considering that data privacy also
              requires strict data security, Epica has implemented processes and procedures to ensure that necessary
              security levels are set in place, such as the encryption and anonymization of Personal Data, the creation
              of processes for data breach notification activities, and the advancement of employee awareness. <br />
              Please note that the contents of this section simply provide information to help you understand how Epica
              addresses certain requirements under the GDPR. None of the contents of this Privacy Policy, including this
              section, are legal advice. <br />
              The Privacy Policy was last updated and reviewed on March 18th 2022.
            </p>
          </div>
        </Container>
      </main>
    </>
  );
};

export default PrivacyPolicy;
