import gsap from 'gsap';

export const timeLine = (svgPathRef, svgWrapperRef, contentRef, fn) => {
  const curve = 'M0 502S175 272 500 272s500 230 500 230V0H0Z';
  const flat = 'M0 2S175 1 500 1s500 1 500 1V0H0Z';
  return gsap
    .timeline()
    .to(document.body, { autoAlpha: 1, duration: 0 })
    .to(svgPathRef.current, {
      duration: 0.5,
      attr: { d: curve },
      ease: 'power2.easeIn',
    })
    .to(svgPathRef.current, {
      duration: 0.5,
      attr: { d: flat },
      ease: 'power2.easeOut',
    })
    .to(svgWrapperRef.current, {
      y: -1500,
    })
    .fromTo(contentRef.current, { y: 100 }, { y: 0, autoAlpha: 1, duration: 0.5, onComplete: fn }, '-=.7');
};
