import { useEffect, lazy, Suspense } from 'react';
import { useSelector, useDispatch } from 'react-redux';
import { Helmet } from 'react-helmet-async';
import { useMediaQuery } from '../helpers/hooks';
import { changeState } from '../store/actions';
import { MobileForm } from '../components';
import { LetsGrowBtn, Container } from '../components';

const Hero = lazy(() => import('../Slides/Hero'));
const Services = lazy(() => import('../Slides/Services'));
const WhatsEpica = lazy(() => import('../Slides/WhatsEpica'));
const SuccessStories = lazy(() => import('../Slides/SuccessStories'));
const ElevateYourBrand = lazy(() => import('../Slides/ElevateYourBrand'));
const TrustedPartners = lazy(() => import('../Slides/TrustedPartners'));

const Home = () => {
  const breakpointLg = useMediaQuery('lg');
  const dispatch = useDispatch();
  const { isMobileFormActive } = useSelector((state) => state.reducers);
  useEffect(() => {
    breakpointLg && dispatch(changeState('isMobileFormActive', false));
    document.documentElement.classList[isMobileFormActive ? 'add' : 'remove']('hidden');
  }, [breakpointLg, isMobileFormActive]);

  return (
    <>
      <Helmet>
        <title>Digital Marketing Agency Miami | Epica Creative Agency</title>
        <meta
          name='description'
          content='We combine data with creativity to develop innovative growth solutions that elevate brands | Powered by UO Solutions'
          data-rh='true'
        />
      </Helmet>

      <main className='e-app'>
        <Container className='container-fixed'>
          <LetsGrowBtn />
        </Container>
        {isMobileFormActive && <MobileForm />}
        <Suspense fallback={null}>
          <Hero />
          <Services />
          <WhatsEpica />
          <SuccessStories />
          <ElevateYourBrand />
          <TrustedPartners />
        </Suspense>
      </main>
    </>
  );
};

export default Home;
