export const scrollToTarget = (target, d) => {
  const easeInQuad = (t) => t * t;
  const duration = d;
  const top = document.querySelector(target).getBoundingClientRect().top;
  const startPos = window.pageYOffset;
  const diff = top;

  let startTime = null;
  let requestId;

  const loop = (currentTime) => {
    if (!startTime) {
      startTime = currentTime;
    }

    const time = currentTime - startTime;

    const percent = Math.min(time / duration, 1);
    window.scrollTo(0, startPos + diff * easeInQuad(percent));

    if (time < duration) requestId = window.requestAnimationFrame(loop);
    else window.cancelAnimationFrame(requestId);
  };
  requestId = window.requestAnimationFrame(loop);
};

export default scrollToTarget;
