import { useEffect, useState } from 'react';
import { useMutation } from 'react-query';

export const useMediaQuery = (breakpoint) => {
  const getMediaQuery = () => {
    const size =
      breakpoint === 'sm'
        ? 576
        : breakpoint === 'md'
        ? 768
        : breakpoint === 'lg'
        ? 900
        : breakpoint === 'xl'
        ? 1200
        : breakpoint === 'xxl'
        ? 1440
        : 1650;
    return window.matchMedia(`(min-width: ${size}px)`).matches;
  };
  const [match, setIsMatch] = useState(getMediaQuery);

  useEffect(() => {
    window.addEventListener('resize', setIsMatch.bind(null, getMediaQuery));
    return () =>
      window.removeEventListener(
        'resize',
        setIsMatch.bind(null, getMediaQuery)
      );
  }, []);
  return match;
};

export const contactFormData = async (formData) => {
  const response = await fetch(
    'https://epica-backend.devuocloud.com/api/v1/contact',
    {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify(formData),
    }
  );
  const data = await response.json();
  return data;
};

export const contactNewsletterData = async (formData) => {
  const response = await fetch(
    'https://epica-backend.devuocloud.com/api/v1/newsletter',
    {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify(formData),
    }
  );
  const data = await response.json();
  return data;
};

export const usePostData = (post, onSuccess, onError) => {
  return useMutation(post, {
    retry: 3,
    onSuccess,
    onError,
  });
};
