export const bounce = (y = 300) => ({
  keyframes: {
    '0%': { yPercent: 0, scaleY: 1, scaleX: 1, ease: 'sine.out' },
    '7%': { yPercent: 5, scaleY: 0.9, scaleX: 1.1, ease: 'sine.in' },
    '25%': { yPercent: 100, scaleY: 1.15, scaleX: 0.9, ease: 'sine.in' },
    '50%': { yPercent: y, scaleY: 1, scaleX: 1, ease: 'none' },
    '60%': { scaleY: 0.4, scaleX: 1.6, ease: 'none' },
    '65%': { yPercent: y, scaleY: 1, scaleX: 1, ease: 'sine.out' },
    '100%': { yPercent: 0, scaleY: 1, scaleX: 1, ease: 'out' },
  },
  duration: 1,
  transformOrigin: 'center bottom',
  repeat: -1,
});
export const rotate = {
  force3D: true,
  rotation: '+=360',
  ease: 'none',
  duration: 1,
  repeat: -1,
  transformOrigin: 'center',
};
export const shadow = {
  scale: 1.4,
  alpha: 0.3,
  duration: 0.5,
  repeat: -1,
  yoyo: true,
  transformOrigin: 'center',
  ease: 'power1.inOut',
};
