import { css } from 'styled-components';

const dflex = (
    justify = null,
    align = null,
    direction = null,
    wrap = null
  ) => css`
    display: flex;
    justify-content: ${justify};
    align-items: ${align};
    flex-direction: ${direction};
    flex-wrap: ${wrap};
  `,
  breakpoint = (size, content) => css`
    @media (min-width: ${size}) {
      ${content}
    }
  `,
  customBreakpoint = (size, orientation, content) => css`
    @media (max-height: ${size}) and (orientation: ${orientation}) {
      ${content}
    }
  `,
  safariOnly = (content) => css`
    @media not all and (min-resolution: 0.001dpcm) {
      @supports (-webkit-appearance: none) {
        ${content};
      }
    }
  `,
  mediaQueryOrientation = (orientation, content) => css`
    @media (orientation: ${orientation}) {
      ${content}
    }
  `;

export {
  dflex,
  breakpoint,
  customBreakpoint,
  safariOnly,
  mediaQueryOrientation,
};
