import { keyframes } from 'styled-components';

const morph = keyframes`
 0%,100%{
  border-radius: 42% 58% 70% 30% / 45% 45% 55% 55%;
    transform: translate3d(0,0,0) rotateZ(0.01deg);
  }
  34%{
      border-radius: 70% 30% 46% 54% / 30% 29% 71% 70%;
    transform:  translate3d(0,.5rem,0) rotateZ(0.01deg);
  }
  50%{
    transform: translate3d(0,0,0) rotateZ(0.01deg);
  }
  67%{
    border-radius: 100% 60% 60% 100% / 100% 100% 60% 60% ;
    transform: translate3d(0,-.3rem,0) rotateZ(0.01deg);
  }
`;
const scale = keyframes`
100% {
    transform: scale(1);
  }
  `;
const scaleX = keyframes`
100% {
    transform: scaleX(1);
  }
  `;

const fadeIn = keyframes`
  100% {
    opacity: 1;
    filter: blur(0);
  }
`;
const translateXInfinite = (x) => keyframes`
  100% {
      -webkit-transform: translateX(calc(${-x}rem / 14 * 7));
      transform: translateX(calc(${-x}rem/ 14 * 7));
  }
`;

const rubberBand = keyframes`
  from {
    -webkit-transform: scale3d(1, 1, 1);
    transform: scale3d(1, 1, 1);
  }

  30% {
    -webkit-transform: scale3d(1.25, 0.75, 1);
    transform: scale3d(1.25, 0.75, 1);
  }

  40% {
    -webkit-transform: scale3d(0.75, 1.25, 1);
    transform: scale3d(0.75, 1.25, 1);
  }

  50% {
    -webkit-transform: scale3d(1.15, 0.85, 1);
    transform: scale3d(1.15, 0.85, 1);
  }

  65% {
    -webkit-transform: scale3d(0.95, 1.05, 1);
    transform: scale3d(0.95, 1.05, 1);
  }

  75% {
    -webkit-transform: scale3d(1.05, 0.95, 1);
    transform: scale3d(1.05, 0.95, 1);
  }

  to {
    -webkit-transform: scale3d(1, 1, 1);
    transform: scale3d(1, 1, 1);
  }

`;

const bounce = keyframes`
  0% {
    transform: translateY(0);
    animation-timing-function: ease-out;
  }
  17% {
    transform: translateY(-3rem);
    animation-timing-function: ease-in;
  }
  34% {
    transform: translateY(0px);
    animation-timing-function: ease-out;
  }

  51% {
    transform: translateY(-1.6rem);
    animation-timing-function: ease-in;
  }
  68% {
    transform: translateY(0);
    animation-timing-function: ease-out;
  }
  85% {
    transform: translateY(-.6rem);
    animation-timing-function: ease-in;
  }
  100% {
    transform: translateY(0);
  }

`;

const translateY = keyframes`
  0% {
    transform: translateY(0) rotate(-90deg);
    animation-timing-function: ease-out;
  }
  50% {
    transform: translateY(-.3rem) rotate(-90deg);
    animation-timing-function: ease-in;
  }
   0% {
    transform: translateY(0) rotate(-90deg);
  }
`;
const bblFadInOut = keyframes`
   0%, 80%, 100% { box-shadow: 0 2.5em 0 -1.3em }
  40% { box-shadow: 0 2.5em 0 0 }
`;
const rotate = keyframes`
   0%   {transform: rotate(0deg)}
        100%   {transform: rotate(360deg)}
`;
const prixClipFix = keyframes`
   0%   {clip-path:polygon(50% 50%,0 0,0 0,0 0,0 0,0 0)}
  50%  {clip-path:polygon(50% 50%,0 0,100% 0,100% 0,100% 0,100% 0)}
  75%, 100%  {clip-path:polygon(50% 50%,0 0,100% 0,100% 100%,100% 100%,100% 100%)}
`;

export {
  morph,
  scale,
  scaleX,
  fadeIn,
  translateXInfinite,
  rubberBand,
  bounce,
  translateY,
  bblFadInOut,
  rotate,
  prixClipFix,
};
