import styled from 'styled-components';
import PropTypes from 'prop-types';
import { useInView } from 'react-intersection-observer';
import CSSStylesSectionHeadings from './CSSStylesSectionHeadings.styled';

const StyledHeadingH2 = styled.h2(CSSStylesSectionHeadings);
const StyledHeadingH5 = styled.h5(CSSStylesSectionHeadings);

const Heading = ({ css: { color, backgroundColor }, text }) => {
  const words = text
    .split(' ')
    .map((w, i) => `<span style="animation-delay: ${i * 0.3}s">${w} </span>`)
    .join('');
  const { ref, inView } = useInView({
    threshold: 1,
    triggerOnce: true,
  });
  return (
    <>
      {text !== 'Who we trust' && text !== 'Trust us' ? (
        <StyledHeadingH2
          color={color}
          backgroundColor={backgroundColor}
          dangerouslySetInnerHTML={{ __html: words }}
          className={inView && 'active'}
          ref={ref}
        />
      ) : (
        <StyledHeadingH5
          color={color}
          backgroundColor={backgroundColor}
          dangerouslySetInnerHTML={{ __html: words }}
          className={inView && 'active'}
          ref={ref}
        />
      )}
    </>
  );
};

Heading.propTypes = {
  css: PropTypes.object.isRequired,
  text: PropTypes.string.isRequired,
};

export default Heading;
