import styled from "styled-components";
import PropTypes from "prop-types";
import { CircleService, OvalService } from "..";
import { breakpoint } from "./styled.mixins";

const StyledSingleService = styled.div`
  /*--width: 100%;
  ${breakpoint(
    "1200px",
    `
   width: 21%;
   margin-right: 12%;
    filter: url("#liquid") `
  )}
  width: var(--width);*/
`;

const SingleService = ({ service }) => {
  return (
    <StyledSingleService className="services__single-service">
      <CircleService text={service.title} />
      <OvalService service={service} bgColor={service.colorCircle} />
    </StyledSingleService>
  );
};

SingleService.propTypes = {
  service: PropTypes.object.isRequired,
};

export default SingleService;
