import styled from 'styled-components';
import { useLocation } from 'react-router-dom';
import { Arrow, ArrowBlack } from '../../assets';
import { dflex } from './styled.mixins';
import scrollToTarget from '../../helpers/scrollToTarget';
import { rubberBand, translateY } from './styled.animations';
import variables from '../../styles/variables.scss';

const { colorBlack1, colorWhite } = variables;

const Btn = styled.button`
  position: absolute;
  line-height: 1;
  top: ${({ position }) => (position === 'bottom' ? 'calc(100% - 7.5rem)' : '3.5rem')};
  z-index: 9;
  right: 2rem;
  width: 4.5rem;
  height: 4.5rem;
  transition: 0.5s ease;
  background: ${({ variant }) => (variant === 'dark' ? colorBlack1 : colorWhite)};
  border-radius: 50%;
  visibility: visible;
  img {
    width: 45%;
    transform: rotate(-90deg);
    animation: ${translateY} 1s both infinite ease;
  }
  ${dflex('center', 'center')}
  &:hover {
    animation: ${rubberBand} 1s both ease;
  }
  &.scroll-top-btn--active {
    opacity: 0;
    visibility: hidden;
  }
`;
const ScrollTopBtn = ({ variant, position }) => {
  const { pathname } = useLocation();

  const clickHandler = () => scrollToTarget(pathname === '/' ? '.hero' : 'main', 1500);

  return (
    <Btn onClick={clickHandler} className={`scroll-top-btn`} variant={variant} position={position}>
      <img src={variant === 'dark' ? Arrow : ArrowBlack} alt='Click on the arrow to scroll to the top of the page' />
    </Btn>
  );
};

ScrollTopBtn.defaultProps = {
  variant: null,
  position: null,
};

export default ScrollTopBtn;
