import styled from "styled-components";
import PropTypes from "prop-types";
import { CircleBtn } from "../";
import { dflex, breakpoint } from "./styled.mixins";
import variables from "../../styles/variables.scss";

const { colorWhite } = variables;

/* const bubblesProperties = () =>
  [...Array(10)].map(
    (el, i) => `
&:nth-child(${i + 1}) {
 left: ${(Math.random() * 19 + 1).toFixed(0)}rem;
 animation: move-${i + 1} ${3 + (i + 1) * 0.02}s infinite;
 animation-delay: ${(i + 1) * 0.2}s;
}
`
  ); */

const Primary = styled.div`
  --size: 7.5rem;
  --max-width: calc(23rem + var(--size));
  --margin: 8rem 0 0;
  /*  ${breakpoint("600px", "--margin: 8rem 0 0")} */
  width: 100%;
  height: var(--size);
  max-width: var(--max-width);
  margin: var(--margin);
  /* filter: url("#liquidBtn"); */
  ${dflex("center", "center", "", "nowrap")}
  * {
    flex-shrink: 0;
    position: relative;
  }
  /* &:hover {
    .circle-btn {
      transform: translateX(5%) scale(1);
      transition-timing-function: cubic-bezier(0.09, 1.98, 0.41, 0.71);
    }
  } */
  p {
    width: calc(100% - var(--size));
    border-radius: 5.5rem;
    height: 100%;
    color: ${colorWhite};
    background: ${({ bgColor }) => bgColor};
    line-height: 1;
    font-weight: 600;
    font-size: 2.6rem;
    margin-top: 0;
    position: relative;
    white-space: nowrap;
    ${dflex("center", "center")}
    z-index: 2;
  }
  .circle-btn {
    animation: none;
    pointer-events: none;
    /*  transform: translateX(-100%) scale(0);
    transition-property: transform;
    transition-duration: 0.5s;
    transition-timing-function: ease; */
  }
`;
const PrimaryBtn = ({ text, bgColor }) => {
  return (
    <Primary bgColor={bgColor} className="mm-btn">
      <p>
        {text}
        {/* <span className="btn-bubbles">
          {[...Array(10)].map((_, i) => (
            <span key={i} className="btn-bubbles__bubble"></span>
          ))}
        </span> */}
      </p>
      <CircleBtn bgColor={bgColor} />
      {/* <SVGFilter type="mainBtn" /> */}
    </Primary>
  );
};

PrimaryBtn.propTypes = {
  text: PropTypes.string.isRequired,
  bgColor: PropTypes.string.isRequired,
};

export default PrimaryBtn;
