import styled from "styled-components";
import { rotate, prixClipFix } from "./styled.animations";
import variables from "../../styles/variables.scss";

const { colorWhite, colorOrange } = variables;

const PreloaderNewsletter = styled.span`
  width: 3rem;
  height: 3rem;
  border-radius: 50%;
  left: 0.5rem;
  position: relative;
  display: inline-block;
  flex-shrink: 0;
  animation: ${rotate} 1s linear infinite;
  &::before,
  &::after {
    content: "";
    box-sizing: border-box;
    position: absolute;
    inset: 0px;
    border-radius: 50%;
    border: 0.3rem solid ${colorWhite};
    animation: ${prixClipFix} 2s linear infinite;
  }
  &::after {
    transform: rotate3d(90, 90, 0, 180deg);
    border-color: ${colorOrange};
  }
`;

export default PreloaderNewsletter;
