import styled from "styled-components";
import { bblFadInOut } from "./styled.animations";
import variables from "../../styles/variables.scss";

const { colorOrange } = variables;

const PreloaderForm = styled.span`
  color: ${colorOrange};
  font-size: 0.4rem;
  position: absolute;
  top: 25%;
  left: 42%;
  transform: translate(-50%, -50%);
  animation-delay: -0.16s;
  border-radius: 50%;
  width: 2.5em;
  height: 2.5em;
  animation-fill-mode: both;
  animation: ${bblFadInOut} 1.8s infinite ease-in-out;
  &:before,
  &:after {
    content: "";
    position: absolute;
    top: 0;
    border-radius: 50%;
    width: inherit;
    height: inherit;
    animation-fill-mode: both;
    animation: inherit;
  }
  &:before {
    left: -3.5em;
    animation-delay: -0.32s;
  }
  &:after {
    left: 3.5em;
  }
`;

export default PreloaderForm;
