import { useSelector } from "react-redux";
import styled from "styled-components";
import PropTypes from "prop-types";
import { CircleBtn } from "../";
import { dflex } from "./styled.mixins";
import variables from "../../styles/variables.scss";

const { colorPink } = variables;

const Oval = styled.div`
  width: 100%;
  max-width: 22rem;
  border-radius: 30rem;
  background: ${colorPink};
  line-height: 1;
  margin: 2.5rem auto 0;
  padding: 8rem 3rem 3rem;

  .service__oval-inner {
    ${dflex("space-between", "center", "column")}
    p {
      font-size: 1.6rem;
      font-weight: 500;
      text-align: center;
      margin-top: 0;
    }
    .circle-btn {
      margin-top: 4rem;
    }
  }
`;
const OvalService = ({ service, bgColor }) => {
  const { serviceColumnHeight } = useSelector((state) => state.reducers);
  return (
    <Oval className="services__oval">
      <div
        className="service__oval-inner"
        style={{ height: `${serviceColumnHeight}` }}
      >
        <p>{service.description}</p>
        <CircleBtn bgColor={bgColor} services={service.title} />
      </div>
    </Oval>
  );
};

OvalService.propTypes = {
  service: PropTypes.object.isRequired,
  bgColor: PropTypes.string.isRequired,
};

export default OvalService;
