import { useEffect, useRef } from 'react';
import { useSelector } from 'react-redux';
import gsap from 'gsap';
import { LogoEpica, LogoEpicaPNG } from '../../assets';
import styled from 'styled-components';
import { bounce, rotate } from '../../helpers/bounceAnimation';

const Link = styled.a`
  position: relative;
  display: inline-block;
  width: 100%;
  svg {
    position: absolute;
    top: ${({ animated }) => (animated ? (/Firefox/.test(navigator.userAgent) ? '-1rem' : '-1.6rem') : '0')};
  }
  img {
    width: inherit;
  }
`;

const Logo = ({ animated, href }) => {
  const { webpSupport } = useSelector((state) => state.reducers);
  const circleRef = useRef(null);
  const circleContainerRef = useRef(null);

  useEffect(() => {
    if (!animated) return;
    gsap.to(circleContainerRef.current, bounce(150), 0);
    gsap.to(circleRef.current, rotate, 0);
  }, []);

  return (
    <Link animated={animated} href={href}>
      <svg
        version='1.1'
        xmlns='http://www.w3.org/2000/svg'
        xmlnsXlink='http://www.w3.org/1999/xlink'
        x='0px'
        y='0px'
        viewBox='0 0 374 178.7'
        style={{ enableBackground: 'new 0 0 374 178.7' }}
        xmlSpace='preserve'
        role='img'
      >
        <g id='ball' ref={circleContainerRef}>
          <circle fill='#FF8100' cx='192.7' cy='17.2' r='17.2' ref={circleRef} />
        </g>
      </svg>
      <img src={webpSupport ? LogoEpica : LogoEpicaPNG} alt='Epica Creative Agency Logotype' />
    </Link>
  );
};

export default Logo;
