import { useSelector, useDispatch } from 'react-redux';
import styled from 'styled-components';
import { useMediaQuery } from '../../helpers/hooks';
import { changeState } from '../../store/actions';
import scrollToTarget from '../../helpers/scrollToTarget';
import { dflex, breakpoint } from './styled.mixins';
import { rubberBand } from './styled.animations';
import variables from '../../styles/variables.scss';

const { colorOrange1, colorWhite } = variables;

const Btn = styled.button`
  --btn-width: 13.5rem;
  --btn-height: 4.5rem;
  ${breakpoint('900px', `--btn-width: 14.4rem; --btn-height: 4.7rem;`)}
  position: absolute;
  line-height: 1;
  top: 0;
  z-index: 9;
  right: 0;
  transition: 0.5s 1s ease;
  background: ${colorOrange1};
  border-radius: 3rem;
  color: ${colorWhite};
  font-weight: 600;
  white-space: nowrap;
  display: block;
  width: var(--btn-width);
  height: var(--btn-height);
  font-size: 1.6rem;
  ${dflex('center', 'center')}
  &:hover {
    animation: ${rubberBand} 1s both ease;
  }
`;
const LetsGrowBtn = () => {
  const { isIntroEnded } = useSelector((state) => state.reducers);
  const breakpointLg = useMediaQuery('lg');
  const dispatch = useDispatch();
  const clickHandler = () => {
    if (breakpointLg) scrollToTarget('.section-contact-form', 1500);
    else dispatch(changeState('isMobileFormActive', true));
  };

  return (
    <Btn
      onClick={clickHandler}
      className='lets-grow-btn'
      style={{ opacity: isIntroEnded ? 1 : 0 }}
      aria-label={breakpointLg ? 'Click to scroll to the form at the bottom of the page' : 'Click to expand the form'}
    >
      Contact us
    </Btn>
  );
};

export default LetsGrowBtn;
