import styled from "styled-components";
import PropTypes from "prop-types";
import { dflex, safariOnly } from "./styled.mixins";
import { translateXInfinite } from "./styled.animations";
import { breakpoint } from "./styled.mixins";
import variables from "../../styles/variables.scss";

const { colorPink2 } = variables;
const carouselWidth = 200;

const StyledCarousel = styled.div`
  --display: none;
  ${breakpoint(
    "900px",
    `
  --display: block;`
  )}
  overflow: hidden;
  margin-bottom: 2rem;
  position: relative;
  &::before,
  &::after {
    content: "";
    position: absolute;
    width: 10%;
    height: 100%;
    top: 0;
    display: var(--display);
    background: linear-gradient(
      to right,
      ${colorPink2} 10%,
      ${colorPink2} 50%,
      transparent 100%
    );
    z-index: 1;
    ${safariOnly("display: none")}
  }
  &::after {
    right: -0.1rem;
    transform: scaleX(-1);
  }
  .infinite-brand {
    &__wrapper {
      width: ${carouselWidth + "rem"};
      ${dflex("space-between")}
      height: 9rem;
    }
    &__logo {
      width: calc(${carouselWidth + "rem"} / 14);
      animation: ${translateXInfinite(carouselWidth)} 13s linear infinite
        ${({ direction }) => direction};
      text-align: center;
      ${dflex("center", "center")}
      &-img {
        height: 7rem;
        &[data-brand="google"] {
          margin-left: -3rem;
        }
        &--who-we-trust {
          height: auto;
          width: 80%;
        }
      }
    }
  }
`;

const InfiniteBrandCarousel = ({ logos, direction, clase }) => {
  return (
    <StyledCarousel direction={direction}>
      <div className="infinite-brand__wrapper">
        {[...logos, ...logos].map((logo, i) => (
          <div className="infinite-brand__logo" key={i}>
            <img
              src={logo.src}
              alt={logo.alt}
              className={`infinite-brand__logo-img${clase ? " " + clase : ""}`}
              data-brand={logo.alt.toLowerCase()}
            />
          </div>
        ))}
      </div>
    </StyledCarousel>
  );
};

InfiniteBrandCarousel.defaultProps = {
  clase: null,
};

InfiniteBrandCarousel.propTypes = {
  logos: PropTypes.array.isRequired,
  direction: PropTypes.string.isRequired,
};

export default InfiniteBrandCarousel;
