import { forwardRef, memo } from 'react';
import styled from 'styled-components';
import variables from '../../styles/variables.scss';
import { dflex, breakpoint, mediaQueryOrientation } from './styled.mixins';
import scrollToTarget from '../../helpers/scrollToTarget';

const { colorWhite, colorOrange1 } = variables;

const StyledDiscoverEpica = styled.div`
  --size-circle: 7.7rem;
  --title-font-size: 1.8rem;
  --margin: 10vw 0 8vw;
  ${mediaQueryOrientation('landscape', '--margin:4vw 0;')}
  ${breakpoint('900px', `--size-circle: 8.2rem; --title-font-size: 2rem;`)}
  background: ${colorOrange1};
  border-radius: 50%;
  width: var(--size-circle);
  height: var(--size-circle);
  outline: 1px solid transparent;
  flex-shrink: 0;
  ${dflex('center', 'center')}
  cursor: pointer;
  opacity: 0;
  margin: var(--margin);

  h3 {
    color: ${colorWhite};
    font-size: var(--title-font-size);
    z-index: 1;
    position: relative;
    display: block;
    white-space: nowrap;
    width: fit-content;
  }
`;

const DiscoverEpica = memo(
  forwardRef(({}, ref) => {
    const clickHandler = () => {
      scrollToTarget('.services', 600);
    };
    return (
      <StyledDiscoverEpica ref={ref} onClick={clickHandler}>
        <h3>Discover Epica</h3>
      </StyledDiscoverEpica>
    );
  })
);

export default DiscoverEpica;
