import styled from 'styled-components';
import { breakpoint, customBreakpoint } from './styled.mixins';

const Container = styled.div`
  --container-width: ${({ inner }) => (inner ? '100%' : '85%')};
  width: var(--container-width);
  max-width: ${({ inner }) => (inner ? '105rem' : '120rem')};
  margin: auto;
  &.container-fixed {
    --top-position: 90%;
    ${customBreakpoint('600px', 'landscape', '--top-position: 85%;')}
    ${breakpoint('900px', `--top-position: 6vh;`)}
    position: fixed;
    left: 50%;
    z-index: 9;
    transform: translateX(-50%);
    top: var(--top-position);
  }
`;

export default Container;
