import styled from 'styled-components';
import PropTypes from 'prop-types';
import { dflex } from './styled.mixins';
import variables from '../../styles/variables.scss';

const { colorPink } = variables;

const Circle = styled.div`
  --size-circle: 22rem;
  width: 55vw;
  height: 55vw;
  max-width: var(--size-circle);
  max-height: var(--size-circle);
  border-radius: 50%;
  background: ${colorPink};
  line-height: 1;
  margin: auto;
  ${dflex('center', 'center')}
  h3 {
    font-size: clamp(2.3rem, 3vw, 2.8rem);
    font-weight: 600;
    text-align: center;
  }
`;
const CircleService = ({ text }) => {
  return (
    <Circle className='services__circle'>
      <h3 dangerouslySetInnerHTML={{ __html: text }}></h3>
    </Circle>
  );
};

CircleService.propTypes = {
  text: PropTypes.string.isRequired,
};

export default CircleService;
