import styled from 'styled-components';
import PropTypes from 'prop-types';
import { useDispatch } from 'react-redux';
import { Arrow } from '../../assets/';
import { dflex } from './styled.mixins';
import { useMediaQuery } from '../../helpers/hooks';
import { formValues, changeState } from '../../store/actions';
import scrollToTarget from '../../helpers/scrollToTarget';
import variables from '../../styles/variables.scss';

const { colorWhite } = variables;

const Circle = styled.button`
  --size: 5rem;
  width: var(--size);
  height: var(--size);
  min-height: var(--size);
  border-radius: 50%;
  background: ${({ bgColor }) => bgColor};
  line-height: 1;
  position: relative;
  transition: 0.4s ease;
  cursor: pointer;
  &:hover {
    width: 12.5rem;
    border-radius: 3rem;
    .circle-btn {
      &__arrow {
        opacity: 0;
        transition-delay: 0s;
      }
      &__message {
        visibility: visible;
        transform: scale(1) translate(-50%, -50%);
        transition-delay: 0.2s;
        opacity: 1;
      }
    }
  }
  ${dflex('center', 'center')}
  .circle-btn {
    &__arrow {
      width: 40%;
      transition: 0.2s 0.4s ease;
      opacity: 1;
    }
    &__message {
      position: absolute;
      left: 50%;
      top: 50%;
      transform: scale(0) translate(-50%, -50%);
      transform-origin: left;
      visibility: hidden;
      transition: 0.3s ease;
      opacity: 0;
      color: ${colorWhite};
      font-weight: 300;
      font-size: 1.6rem;
      white-space: nowrap;
    }
  }
`;
const CircleBtn = ({ bgColor, services }) => {
  const dispatch = useDispatch();
  const breakpointLg = useMediaQuery('lg');
  const clickHandler = () => {
    dispatch(formValues('message', { value: services.replace('<br>', ' '), validated: true }));
    if (breakpointLg) scrollToTarget('.section-contact-form', 1500);
    else dispatch(changeState('isMobileFormActive', true));
  };
  return (
    <Circle bgColor={bgColor} className='circle-btn' onClick={clickHandler}>
      <img
        className='circle-btn__arrow'
        src={Arrow}
        alt='Click the white arrow to fill "Your needs" input and scroll to the form'
      />
      <span className='circle-btn__message'>I want this!</span>
    </Circle>
  );
};

CircleBtn.defaultProps = {
  services: null,
};

CircleBtn.propTypes = {
  bgColor: PropTypes.string.isRequired,
};

export default CircleBtn;
