import styled, { css } from 'styled-components';
import { scale, fadeIn, scaleX } from './styled.animations';

const CSSStylesSectionHeadings = () => css`
  --font-size: 3.2rem;
  --width: 7.2rem;
  --height: 2.7rem;
  --bottom: -1.3rem;
  --width-h2: 27rem;
  @media (min-width: 900px) {
    --font-size: 3.8rem;
    --width: 5.8rem;
    --height: 2.2rem;
    --bottom: -0.5rem;
    --width-h2: 70%;
  }
  position: relative;
  transform: scale(0.8);
  transform-origin: left;
  width: var(--width-h2);
  margin-bottom: 4rem;

  span {
    position: inherit;
    font-size: var(--font-size);
    color: ${({ color }) => color};
    z-index: 1;
    line-height: 1;
    opacity: 0;
    filter: blur(0.9rem);
  }
  &::before {
    content: '';
    position: absolute;
    width: var(--width);
    height: var(--height);
    left: -1.5rem;
    bottom: var(--bottom);
    background-color: ${({ backgroundColor }) => backgroundColor};
    border-radius: 3.7rem;
    z-index: 0;
    transform: scaleX(0);
    transform-origin: left;
  }
  &.active {
    animation: ${scale} 2s forwards cubic-bezier(0.5, 1, 0.89, 1);
    span {
      animation: ${fadeIn} 0.8s forwards cubic-bezier(0.11, 0, 0.5, 0);
    }
    &::before {
      animation: ${scaleX} 0.4s 1.4s forwards ease-out;
    }
  }
`;

export default CSSStylesSectionHeadings;
