import styled from 'styled-components';
import { useSelector } from 'react-redux';
import { Canvas } from '@react-three/fiber';
import { Suspense, forwardRef } from 'react';
import Mesh from './Mesh';
import { Texture, TexturePng } from '../../assets';

const SphereContainer = styled.div`
  position: absolute;
  width: 100%;
  height: 100%;
  opacity: 0;
`;

const Sphere = forwardRef(({}, ref) => {
  const { webpSupport } = useSelector((state) => state.reducers);
  return (
    <SphereContainer ref={ref}>
      <Canvas
        gl={{
          powerPreference: 'high-performance',
          antialias: true,
        }}
      >
        <Suspense fallback={null}>
          <Mesh txture={webpSupport ? Texture : TexturePng} />
        </Suspense>
      </Canvas>
    </SphereContainer>
  );
});

export default Sphere;
