import PropTypes from 'prop-types';
import { useRef } from 'react';
import { useFrame, useLoader } from '@react-three/fiber';
import { TextureLoader } from 'three/src/loaders/TextureLoader';
import * as THREE from 'three';

const Mesh = ({ txture }) => {
  const sphereRef = useRef(null);
  const texture = useLoader(TextureLoader, txture);

  useFrame(({ clock }) => {
    const elapsedTime = clock.getElapsedTime();
    sphereRef.current.rotation.y = elapsedTime / 1.3;
  });

  return (
    <mesh ref={sphereRef} position={[0, 0, 4.1]}>
      <sphereBufferGeometry args={[1, 64, 32]} />
      <meshBasicMaterial
        map={texture}
        transparent
        side={THREE.BackSide}
        depthWrite={true}
        opacity={0.6}
      />
    </mesh>
  );
};

Mesh.propTypes = {
  txture: PropTypes.string.isRequired,
};

export default Mesh;
