import PropTypes from 'prop-types';
import { SingleService } from '../../components';
import { Swiper, SwiperSlide } from 'swiper/react';
import { Pagination } from 'swiper';

const ServicesMobile = ({ data }) => {
  return (
    <Swiper
      pagination={{ clickable: true }}
      modules={[Pagination]}
      resistanceRatio={false}
      breakpoints={{
        600: {
          slidesPerView: 2,
          slidesPerGroup: 2,
        },
        800: {
          slidesPerView: 3,
          slidesPerGroup: 3,
        },
        1200: {
          slidesPerView: 4,
          slidesPerGroup: 4,
        },
      }}
      className='services__service-wrapper'
    >
      {data.map((service, i) => (
        <SwiperSlide key={i}>
          <SingleService service={service} />
        </SwiperSlide>
      ))}
    </Swiper>
  );
};

ServicesMobile.propTypes = {
  data: PropTypes.array.isRequired,
};

export default ServicesMobile;
