import { useEffect, useRef, createRef, forwardRef, memo } from 'react';
import { gsap } from 'gsap';
import ChevronDown from './ChevronDown';
import gsapAnimation from './animations';
import './style.scss';

const ScrollDownMouse = memo(
  forwardRef(({}, ref) => {
    const DOMElementRefs = useRef([...Array(2)].map((_) => createRef(null)));
    const [mouseBall, mouseChevron] = DOMElementRefs.current;
    useEffect(() => {
      const animatedElements = [mouseBall, mouseChevron];
      gsapAnimation(gsap, ...animatedElements);
    }, []);
    return (
      <div className='e-mouse' ref={ref}>
        <div className='e-mouse__container'>
          <span className='e-mouse__ball' ref={mouseBall}></span>
        </div>
        <div className='e-mouse__arrows' ref={mouseChevron}>
          {[...Array(2)].map((_, i) => (
            <ChevronDown key={i} />
          ))}
        </div>
      </div>
    );
  })
);

export default ScrollDownMouse;
