import { useEffect } from 'react';
import { useSelector } from 'react-redux';
import { gsap } from 'gsap';
import { bounce, shadow, rotate } from '../../helpers/bounceAnimation';
import './style.scss';

const BouncingBall = () => {
  const { webpSupport } = useSelector((state) => state.reducers);
  useEffect(() => {
    gsap.to('.e-bouncing-ball__ball', bounce(), 0);
    gsap.to('.e-bouncing-ball__shadow', shadow, 0);
    gsap.to('.e-bouncing-ball__ball-rotate', rotate, 0);
  }, []);
  return (
    <div className='e-bouncing-ball'>
      <div className='e-bouncing-ball__container'>
        <div className='e-bouncing-ball__ball'>
          <div
            className={`e-bouncing-ball__ball-rotate ${
              webpSupport ? 'e-bouncing-ball__ball-rotate--webp' : 'e-bouncing-ball__ball-rotate--nowebp'
            }`}
          ></div>
        </div>
        <div className='e-bouncing-ball__shadow'></div>
      </div>
    </div>
  );
};

export default BouncingBall;
