import { useState } from 'react';
import { useDispatch } from 'react-redux';
import { changeState } from '../../store/actions';
import { Container, ContactForm } from '../';
import './style.scss';

const MobileForm = () => {
  const [slideOut, setSlideOut] = useState(false);
  const dispatch = useDispatch();
  return (
    <section
      className={`mobile-form${slideOut ? ' mobile-form--inactive' : ''}`}
      onAnimationEnd={() => {
        if (slideOut) dispatch(changeState('isMobileFormActive', false));
      }}
    >
      <Container>
        <button
          className='mobile-form__close-btn'
          onClick={setSlideOut.bind(null, true)}
          aria-label='Collapse modal'
        >
          X
        </button>
        <div className='mobile-form__inner-container'>
          <h3 className='mobile-form__headline'>
            We’d love to hear about you and start an epic journey of growth
            together. <span>Are you in?</span>
          </h3>
          <ContactForm clase='.mobile-form' />
        </div>
      </Container>
    </section>
  );
};

export default MobileForm;
