import PropTypes from 'prop-types';
import { useRef, createRef, useEffect } from 'react';
import { useSelector } from 'react-redux';
import gsap from 'gsap';
import { svgAnimation } from '../../Slides/Hero/animations';

const MainLogo = ({ hero }) => {
  const { isIntroEnded } = useSelector((state) => state.reducers);
  const SVGElementRefs = useRef([...Array(5)].map((_) => createRef(null)));
  const [weAre, epica, slogan, line, circle] = SVGElementRefs.current;

  useEffect(() => {
    svgAnimation(
      gsap,
      ...Object.values(SVGElementRefs)[0].map((el) => el.current),
      hero
    );
  }, [isIntroEnded]);
  return (
    <svg
      x='0px'
      y='0px'
      viewBox='0 0 961.8 352.3'
      style={{ enableBackground: 'new 0 0 961.8 352.3' }}
      xmlSpace='preserve'
      className='hero__main-logo'
    >
      <g ref={weAre}>
        <path
          fill='#ffffff'
          d='M103.1,225.8l-18.5-63.7h-0.3l-18.7,63.7H33.8L0,111.9h32.8l18.5,67.6h0.3l19.9-67.6H98l19.7,68h0.3l18.9-68
		h31.9l-34,114H103.1z'
        />
        <path
          fill='#ffffff'
          d='M197,191c2.4,9.3,10.8,13.4,22.3,13.4c11.3,0,21.1-3.1,27.1-8.9h1V221c-6.3,4.1-17.2,6.5-29.7,6.5
		c-28.7,0-48.6-17.5-48.6-42.2c0-24.7,17.5-42.2,42.2-42.2c25.1,0,40.7,14.9,40.7,38.8v9.1H197z M197,177.6h30.5
		c-1.7-7.7-7.6-11.3-15.3-11.3C205.4,166.3,198.9,170.1,197,177.6z'
        />
        <path
          fill='#ffffff'
          d='M364.7,225.8l-1-9.8h-0.3c-4.6,7.4-12.5,11.5-23.2,11.5c-22.5,0-39-17.8-39-42.2c0-24.4,16.5-42.2,39-42.2
		c10.6,0,18.5,4.1,23.2,11.5h0.3l1-9.8h22.7v81H364.7z M360.6,185.3c0-10.6-6.3-17.8-15.8-17.8s-15.8,7.2-15.8,17.8
		s6.3,17.8,15.8,17.8S360.6,196,360.6,185.3z'
        />
        <path
          fill='#ffffff'
          d='M465.9,146.2v26.6h-1c-3.3-2.2-7.9-3.6-12.9-3.6c-12.5,0-17.8,7-17.8,23.2v33.5h-27.5v-81h22.7l1.4,12.9h0.3
		c4.3-9.8,11.7-14.6,23.2-14.6C459.3,143.1,463.7,144.3,465.9,146.2z'
        />
        <path
          fill='#ffffff'
          d='M501,191c2.4,9.3,10.8,13.4,22.3,13.4c11.3,0,21.1-3.1,27.1-8.9h1V221c-6.3,4.1-17.2,6.5-29.7,6.5
		c-28.7,0-48.6-17.5-48.6-42.2c0-24.7,17.5-42.2,42.2-42.2c25.1,0,40.7,14.9,40.7,38.8v9.1H501z M501,177.6h30.5
		c-1.7-7.7-7.6-11.3-15.3-11.3C509.4,166.3,502.8,170.1,501,177.6z'
        />
      </g>
      <path
        className='line'
        fill='#F87E12'
        ref={line}
        d='M868.3,345.3h-352c-11.3,0-20.5-9.2-20.5-20.5v0c0-11.3,9.2-20.5,20.5-20.5h352
	c11.3,0,20.5,9.2,20.5,20.5v0C888.8,336.1,879.5,345.3,868.3,345.3z'
      />
      <g className='epica' ref={epica}>
        <path
          id='e'
          fill='#FFFFFF'
          d='M628.9,190.7c0.8,13.8,7.1,20.5,18.7,20.5c11.1,0,16.9-6.7,16.9-13.1h19.3v0.6
	c0,15.1-12.5,28.5-36.4,28.5c-26.8,0-38.9-18.1-38.9-42.2V181c0-24,12.4-42.2,38.1-42.2c25.6,0,37.2,18.1,37.2,42.2v9.7H628.9z
	 M628.9,175.4h34.4c-0.6-13.4-6-20.5-17.1-20.5C635.1,154.9,629.6,162.1,628.9,175.4'
        />
        <path
          id='p'
          fill='#FFFFFF'
          d='M714.9,216.3v39h-21v-90.9l-1.3-23.5h18.6l1.8,10.3c4.7-7.1,12.5-12.4,24.7-12.4c23.5,0,32,17.2,32,41.1
	v5c0,23.7-8.6,41.1-32,41.1C727.1,226,719.8,222.1,714.9,216.3 M714.9,198.7c2.6,3.9,7.9,9.4,16.8,9.4c12,0,17-8.6,17-23.2v-5
	c0-14.6-5-23.4-17-23.4c-8.9,0-14.2,5.6-16.8,9.6V198.7z'
        />
        <rect
          id='i'
          x='780'
          y='138.6'
          fill='#FFFFFF'
          width='19.8'
          height='86.7'
        />
        <path
          id='c'
          fill='#FFFFFF'
          d='M846.9,209.2c10.6,0,15.1-6.4,15.1-14.6h19.8v3.3c0,16.1-11.3,29.4-35.4,29.4
	c-26.2,0-37.6-17.7-37.6-41.7v-5.1c0-24.2,11.4-41.7,37.6-41.7c24.1,0,35.4,13.7,35.4,30.7v3.5H862c0-9.9-4.8-16.2-15.1-16.2
	c-12.2,0-17.2,9.1-17.2,23.7v5.1C829.7,200.1,834.6,209.2,846.9,209.2'
        />
        <path
          id='a'
          fill='#FFFFFF'
          d='M942.5,215.5c-5.7,6.8-14.5,11.8-26.6,11.8c-17.2,0-24.6-11.3-24.6-24.8v-1.6c0-18.3,12.6-24,28.5-26.4
	l20.8-3.3v-0.3c0-10.7-3.2-15.9-13.5-15.9c-11.1,0-13.5,6.5-13.5,13.8h-19.1v-1.4c0-14.2,7.1-28.5,33.1-28.5
	c25.4,0,33.1,12.3,33.1,32v30.6l1.2,23.9h-17.7L942.5,215.5z M940.5,201.5v-17.8l-17.1,2.9c-8.5,1.4-12.2,5.6-12.2,12.1v1.3
	c0,5.3,3.4,10.3,11.5,10.3C932.2,210.3,937.9,205.2,940.5,201.5'
        />
      </g>
      <path
        fill='#F87E12'
        ref={circle}
        d='M806.8,21.9c0,8.8-7.1,15.9-15.9,15.9c-8.8,0-15.9-7.1-15.9-15.9c0-8.8,7.1-15.9,15.9-15.9
	C799.7,6,806.8,13.1,806.8,21.9'
      />
      <g ref={slogan}>
        <path
          fill='#FFFFFF'
          d='M174.8,319.7h-12.9l-1.7,4.6H151l13.2-32.2h8.6l13.2,32.2h-9.5L174.8,319.7z M168.3,302.3l-3.6,10h7.4
		L168.3,302.3L168.3,302.3z'
        />
        <path
          fill='#FFFFFF'
          d='M231.5,324.3v-21.9h-0.1l-7.6,21.9h-7.5l-7.3-21h-0.1v21h-8.5v-32.2h13.1l6.6,19.5h0.1l6.6-19.5h13.4v32.2
		H231.5z'
        />
        <path
          fill='#FFFFFF'
          d='M254.6,294.4c0,2.7-1.9,4.6-4.6,4.6c-2.7,0-4.6-1.9-4.6-4.6c0-2.7,1.9-4.6,4.6-4.6
		C252.7,289.8,254.6,291.7,254.6,294.4z M246.1,301.4h7.8v22.9h-7.8V301.4z'
        />
        <path
          fill='#FFFFFF'
          d='M275.8,324.3l-0.3-2.8h-0.1c-1.3,2.1-3.5,3.2-6.5,3.2c-6.4,0-11-5-11-11.9s4.7-11.9,11-11.9
		c3,0,5.2,1.2,6.5,3.2h0.1l0.3-2.8h6.4v22.9H275.8z M274.6,312.9c0-3-1.8-5-4.5-5s-4.5,2-4.5,5s1.8,5,4.5,5S274.6,315.9,274.6,312.9
		z'
        />
        <path
          fill='#FFFFFF'
          d='M322.8,310.6v13.7h-7.8v-12.8c0-2.4-1-3.7-2.8-3.7c-2.1,0-3.2,1.4-3.2,4.8v11.7h-7.8v-12.8
		c0-2.4-1-3.7-2.8-3.7c-2.1,0-3.2,1.4-3.2,4.1v12.4h-7.8v-22.9h6.4l0.3,2.9h0.1c1.2-2.2,3.3-3.4,6.3-3.4c2.9,0,5.1,1.2,6.6,3.4h0.1
		c1.4-2.2,3.5-3.4,7.1-3.4C319.7,300.9,322.8,304.5,322.8,310.6z'
        />
        <path
          fill='#FFFFFF'
          d='M336.1,294.4c0,2.7-1.9,4.6-4.6,4.6c-2.7,0-4.6-1.9-4.6-4.6c0-2.7,1.9-4.6,4.6-4.6
		C334.2,289.8,336.1,291.7,336.1,294.4z M327.6,301.4h7.8v22.9h-7.8V301.4z'
        />
        <path fill='#FFFFFF' d='M340,307H354v7.9H340V307z' />
        <path
          fill='#FFFFFF'
          d='M381.1,308c3.5,1.2,5.2,3.7,5.2,7.3c0,6-4,9-11.6,9h-15.5v-32.2h14.3c7.7,0,11.7,3.1,11.7,9
		C385.2,304.3,383.8,306.6,381.1,308L381.1,308z M372.7,304.7c2.5,0,3.6-0.9,3.6-2.4s-1-2.3-3-2.3H368v4.8H372.7z M374.4,316.5
		c2,0,3-0.8,3-2.3s-1.1-2.4-3.6-2.4H368v4.8H374.4z'
        />
        <path
          fill='#FFFFFF'
          d='M407,324.3l-0.3-2.8h-0.1c-1.3,2.1-3.5,3.2-6.5,3.2c-6.4,0-11-5-11-11.9s4.7-11.9,11-11.9c3,0,5.2,1.2,6.5,3.2
		h0.1l0.3-2.8h6.4v22.9H407z M405.8,312.9c0-3-1.8-5-4.5-5s-4.5,2-4.5,5s1.8,5,4.5,5S405.8,315.9,405.8,312.9z'
        />
        <path
          fill='#FFFFFF'
          d='M434.7,302.4v6.8h-0.3c-1.5-1.5-3.8-2.3-6.6-2.3c-2,0-3.1,0.6-3.1,1.6c0,0.8,0.7,1.2,3.3,1.4
		c5.8,0.4,8.2,2.6,8.2,7.2c0,4.8-3.5,7.7-9.7,7.7c-3.8,0-6.7-0.7-8.6-2v-6.9h0.3c1.9,1.9,4.6,2.9,8,2.9c1.9,0,3-0.6,3-1.6
		c0-1-0.8-1.4-3.6-1.6c-5.6-0.5-7.9-2.5-7.9-6.7c0-4.8,3.8-7.9,9.9-7.9C430.4,300.9,432.9,301.5,434.7,302.4z'
        />
        <path
          fill='#FFFFFF'
          d='M446.7,314.5c0.7,2.6,3.1,3.8,6.3,3.8c3.2,0,6-0.9,7.7-2.5h0.3v7.2c-1.8,1.2-4.8,1.8-8.4,1.8
		c-8.1,0-13.7-4.9-13.7-11.9c0-7,4.9-11.9,11.9-11.9c7.1,0,11.5,4.2,11.5,11v2.6H446.7z M446.7,310.7h8.6c-0.5-2.2-2.1-3.2-4.3-3.2
		C449,307.5,447.2,308.6,446.7,310.7z'
        />
        <path
          fill='#FFFFFF'
          d='M482.9,324.3l-0.3-2.8h-0.1c-1.3,2.1-3.5,3.2-6.5,3.2c-6.4,0-11-5-11-11.9s4.7-11.9,11-11.9
		c2.3,0,4.1,0.7,5.5,1.9h0.1v-12.5h7.8v33.9H482.9z M481.7,312.9c0-3-1.8-5-4.5-5s-4.5,2-4.5,5s1.8,5,4.5,5S481.7,315.9,481.7,312.9
		z'
        />
        <path
          fill='#FFFFFF'
          d='M530.8,293.8v9.6h-0.4c-1.9-2.5-4.9-3.8-8.7-3.8c-5.3,0-8.8,3.4-8.8,8.7c0,5.3,3.5,8.7,8.8,8.7
		c3.8,0,6.8-1.4,8.7-3.8h0.4v9.6c-2.6,1.5-5.1,2.1-9.6,2.1c-10.3,0-17.3-6.9-17.3-16.6s7-16.6,17.3-16.6
		C525.7,291.6,528.2,292.3,530.8,293.8z'
        />
        <path
          fill='#FFFFFF'
          d='M552.3,301.8v7.5H552c-0.9-0.6-2.2-1-3.6-1c-3.5,0-5,2-5,6.5v9.5h-7.8v-22.9h6.4l0.4,3.6h0.1
		c1.2-2.8,3.3-4.1,6.5-4.1C550.4,300.9,551.7,301.3,552.3,301.8z'
        />
        <path
          fill='#FFFFFF'
          d='M562,314.5c0.7,2.6,3.1,3.8,6.3,3.8c3.2,0,6-0.9,7.7-2.5h0.3v7.2c-1.8,1.2-4.8,1.8-8.4,1.8
		c-8.1,0-13.7-4.9-13.7-11.9c0-7,4.9-11.9,11.9-11.9c7.1,0,11.5,4.2,11.5,11v2.6H562z M562,310.7h8.6c-0.5-2.2-2.1-3.2-4.3-3.2
		C564.4,307.5,562.5,308.6,562,310.7z'
        />
        <path
          fill='#FFFFFF'
          d='M598.2,324.3l-0.3-2.8h-0.1c-1.3,2.1-3.5,3.2-6.5,3.2c-6.4,0-11-5-11-11.9s4.7-11.9,11-11.9
		c3,0,5.2,1.2,6.5,3.2h0.1l0.3-2.8h6.4v22.9H598.2z M597.1,312.9c0-3-1.8-5-4.5-5s-4.5,2-4.5,5s1.8,5,4.5,5S597.1,315.9,597.1,312.9
		z'
        />
        <path
          fill='#FFFFFF'
          d='M625.3,324.1c-1.2,0.5-2.6,0.7-4.7,0.7c-6,0-9.1-3.2-9.1-9.4V308h-3.5v-6.6h3.8l0.9-6.5h6.6v6.5h6v6.6h-6v7.1
		c0,1.8,1,2.8,2.7,2.8c1.1,0,2.1-0.2,3.1-1.3h0.3V324.1z'
        />
        <path
          fill='#FFFFFF'
          d='M637.9,294.4c0,2.7-1.9,4.6-4.6,4.6s-4.6-1.9-4.6-4.6c0-2.7,1.9-4.6,4.6-4.6S637.9,291.7,637.9,294.4z
		 M629.5,301.4h7.8v22.9h-7.8V301.4z'
        />
        <path
          fill='#FFFFFF'
          d='M648.5,324.3l-8.4-22.9h8.3l4.1,13.8h0.1l4.1-13.8h8l-8.4,22.9H648.5z'
        />
        <path
          fill='#FFFFFF'
          d='M673.2,314.5c0.7,2.6,3.1,3.8,6.3,3.8c3.2,0,6-0.9,7.7-2.5h0.3v7.2c-1.8,1.2-4.8,1.8-8.4,1.8
		c-8.1,0-13.7-4.9-13.7-11.9c0-7,4.9-11.9,11.9-11.9c7.1,0,11.5,4.2,11.5,11v2.6H673.2z M673.2,310.7h8.6c-0.5-2.2-2.1-3.2-4.3-3.2
		C675.6,307.5,673.7,308.6,673.2,310.7z'
        />
        <path
          fill='#FFFFFF'
          d='M725.1,319.7h-12.9l-1.7,4.6h-9.2l13.2-32.2h8.6l13.2,32.2h-9.5L725.1,319.7z M718.6,302.3l-3.6,10h7.4
		L718.6,302.3L718.6,302.3z'
        />
        <path
          fill='#FFFFFF'
          d='M762,322.5c0,7.1-5,11.5-13,11.5c-3.7,0-6.9-0.8-9-2.1v-7.8h0.3c1.6,1.8,4.6,3,7.8,3c3.8,0,6-1.7,6.2-4.8h-0.1
		c-1.4,1.3-3.2,1.9-5.5,1.9c-6.4,0-11-4.8-11-11.7s4.7-11.7,11-11.7c3,0,5.2,1.2,6.5,3.2h0.1l0.3-2.8h6.4V322.5z M754.5,312.6
		c0-3-1.8-4.8-4.5-4.8s-4.5,1.8-4.5,4.8s1.8,4.8,4.5,4.8S754.5,315.6,754.5,312.6z'
        />
        <path
          fill='#FFFFFF'
          d='M773.9,314.5c0.7,2.6,3.1,3.8,6.3,3.8c3.2,0,6-0.9,7.7-2.5h0.3v7.2c-1.8,1.2-4.8,1.8-8.4,1.8
		c-8.1,0-13.7-4.9-13.7-11.9c0-7,4.9-11.9,11.9-11.9c7.1,0,11.5,4.2,11.5,11v2.6H773.9z M773.9,310.7h8.6c-0.5-2.2-2.1-3.2-4.3-3.2
		C776.3,307.5,774.4,308.6,773.9,310.7z'
        />
        <path
          fill='#FFFFFF'
          d='M815.3,310.6v13.7h-7.8v-12.8c0-2.4-1.1-3.7-3-3.7c-2.2,0-3.4,1.4-3.4,4.1v12.4h-7.8v-22.9h6.4l0.3,2.9h0.1
		c1.3-2.2,3.5-3.3,6.5-3.3C812.1,300.9,815.3,304.5,815.3,310.6z'
        />
        <path
          fill='#FFFFFF'
          d='M838.3,302.3v8.2H838c-1.4-1.8-3.2-2.7-5.7-2.7c-3.5,0-5.5,1.9-5.5,5s2,5,5.5,5c2.5,0,4.4-0.9,5.7-2.8h0.3v8.3
		c-1.6,1-3.7,1.4-6.8,1.4c-7.5,0-12.6-4.9-12.6-11.9s5.1-11.9,12.6-11.9C834.6,300.9,836.6,301.4,838.3,302.3z'
        />
        <path
          fill='#FFFFFF'
          d='M844.8,333.5l4.1-9.9l-8.3-22.2h8.3l4.1,13.2h0.1l4.1-13.2h8l-12.4,32.1H844.8z'
        />
      </g>
    </svg>
  );
};

MainLogo.propTypes = {
  hero: PropTypes.object.isRequired,
};

export default MainLogo;
