import { useEffect, useRef } from 'react';
import { useSelector, useDispatch } from 'react-redux';
import { changeState } from '../../store/actions';
import { Player } from '@lottiefiles/react-lottie-player';
import introAnimationDesktop from '../../assets/intro-desktop.json';
import introAnimationMobile from '../../assets/intro-mobile.json';

const MainIntro = () => {
  const { orientation, isIntroLoaded, isIntroEnded, isIntroPlaying } =
    useSelector((state) => state.reducers);
  const introEvents = [
    { e: 'load', property: 'isIntroLoaded' },
    { e: 'play', property: 'heroBgColor' },
    { e: 'complete', property: 'isIntroEnded' },
  ];
  const dispatch = useDispatch();
  const getDeviceOrientation = () =>
    dispatch(
      changeState(
        'orientation',
        window.matchMedia('(orientation: landscape)').matches
          ? 'landscape'
          : 'portrait'
      )
    );
  const playerStyleProps = {
    height: '100%',
    width: '100%',
    position: 'absolute',
    top: '0',
    opacity: isIntroPlaying ? 1 : 0,
  };
  const lottiePlayer = useRef(null);
  useEffect(() => {
    if (isIntroEnded) return;
    isIntroLoaded &&
      setTimeout(() => {
        lottiePlayer.current.play();
        dispatch(changeState('isIntroPlaying', true));
      }, 500);
    window.addEventListener('resize', getDeviceOrientation);
    return () => window.removeEventListener('resize', getDeviceOrientation);
  }, [isIntroLoaded, orientation]);
  return (
    <>
      {!isIntroEnded && (
        <Player
          onEvent={(event) => {
            introEvents.forEach(
              (e) => event === e.e && dispatch(changeState(e.property, true))
            );
          }}
          ref={lottiePlayer}
          autoplay={false}
          loop={false}
          src={
            orientation === 'landscape'
              ? introAnimationDesktop
              : introAnimationMobile
          }
          style={{ ...playerStyleProps }}
          rendererSettings={{
            preserveAspectRatio: 'xMidYMid slice',
          }}
        ></Player>
      )}
    </>
  );
};

export default MainIntro;
