import PropTypes from "prop-types";
import { useSelector, useDispatch } from "react-redux";
import { changeState, formValues } from "../../store/actions";
import "./style.scss";

const InputForm = ({ inputProps, label }) => {
  const { form } = useSelector((state) => state.reducers);
  const dispatch = useDispatch();
  const onChangeEventHandler = (e) => {
    const validated =
      e.target.name === "email"
        ? e.target.value !== "" &&
          /^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/i.test(e.target.value)
        : e.target.value !== "";
    if (inputProps.name === "phone") {
      !/^[0-9\s-]*$/i.test(e.target.value.charAt(e.target.value.length - 1)) &&
        (e.target.value = e.target.value.slice(0, -1));
    }
    dispatch(formValues(e.target.name, { value: e.target.value, validated }));
  };
  return (
    <div className="form__group">
      <label htmlFor={inputProps.name} className="form__label">
        {label}
      </label>
      <input
        className="form__input"
        {...inputProps}
        onChange={onChangeEventHandler}
        onFocus={() =>
          dispatch(changeState("formSelectedLabel", inputProps.name))
        }
      />
      {form.submit && !form[inputProps.name].validated && (
        <p className="form__message">
          {inputProps.value !== "" && !form[inputProps.name].validated
            ? "Please enter a valid email address."
            : "This field is required."}
        </p>
      )}
    </div>
  );
};

InputForm.propTypes = {
  inputProps: PropTypes.object.isRequired,
  label: PropTypes.string.isRequired,
};

export default InputForm;
