import "./style.scss";

const InfiniteMarquee = ({ direction }) => {
  return (
    <div className="infinite-marquee">
      <h3 className="infinite-marquee__headline">
        {[...Array(20)].map((_, i) => (
          <span
            key={i}
            className={`infinite-marquee__headline__span${
              direction === "reverse"
                ? " infinite-marquee__headline__span--reverse"
                : ""
            }`}
          >
            <small>&#8226;</small>Creativity<small>&#8226;</small>Performance
            <small>&#8226;</small>Social Media
          </span>
        ))}
      </h3>
    </div>
  );
};

InfiniteMarquee.defaultProps = {
  direction: null,
};

export default InfiniteMarquee;
