import { forwardRef, memo } from 'react';
import { Container, Logo } from '..';
import './style.scss';

const Header = memo(
  forwardRef(({}, ref) => {
    return (
      <header className='header' ref={ref}>
        <Container>
          <nav className='header__nav'>
            <div className='header__logo'>
              <Logo />
            </div>
          </nav>
        </Container>
      </header>
    );
  })
);

export default Header;
