import PropTypes from 'prop-types';
import { useState, useRef, useEffect, useCallback } from 'react';
import { useSelector, useDispatch } from 'react-redux';
import { usePostData, contactFormData } from '../../helpers/hooks';
import Swal from 'sweetalert2';
import { formValues, changeState } from '../../store/actions';
import { InputForm, PreloaderForm } from '../';
import { Arrow } from '../../assets';
import './style.scss';

const ContactForm = ({ clase }) => {
  const { form, formSelectedLabel } = useSelector((state) => state.reducers);
  const dispatch = useDispatch();
  const formCircle = useRef(null);
  const formulario = useRef(null);
  const [circleProperties, setCircleProperties] = useState({});
  const formInputs = [
    {
      label: 'Your name',
      inputProps: {
        type: 'text',
        name: 'name',
        id: 'name',
        value: form['name'].value,
      },
    },
    {
      label: 'Your email',
      inputProps: {
        type: 'email',
        name: 'email',
        id: 'email',
        value: form['email'].value,
      },
    },
    {
      label: 'Your company’s name',
      inputProps: {
        type: 'text',
        name: 'company',
        id: 'company',
        value: form['company'].value,
      },
    },
    {
      label: 'Your phone',
      inputProps: {
        type: 'text',
        name: 'phone',
        id: 'phone',
        value: form['phone'].value,
      },
    },
    {
      label: 'Your needs',
      inputProps: {
        type: 'text',
        name: 'message',
        id: 'message',
        value: form['message'].value,
      },
    },
  ];
  const onSuccess = () => {
    Swal.fire({
      icon: 'success',
      title: 'Thank you!',
      text: "We've received your message. Someone from our team will contact you soon.",
      showConfirmButton: true,
      confirmButtonText: 'Close',
    });
    dispatch(
      changeState('form', {
        name: { value: '', validated: false },
        email: { value: '', validated: false },
        company: { value: '', validated: false },
        phone: { value: '', validated: false },
        message: { value: '', validated: false },
        submit: false,
      })
    );
    dispatch(changeState('formSelectedLabel', 'name'));
  };
  const onError = () => {
    Swal.fire({
      icon: 'error',
      title: 'Error!',
      text: 'There was an error trying to send your message. Please try again later.',
      showConfirmButton: true,
      confirmButtonText: 'Close',
    });
  };
  const { mutate, isLoading } = usePostData(contactFormData, onSuccess, onError);
  const submitEventHandler = (e) => {
    e.preventDefault();
    dispatch(formValues('submit', true));
    const invalidFields = [];

    const validatedInputs = Object.entries(form).filter(([key, value]) => {
      typeof value !== 'boolean' && !value.validated && invalidFields.push(key === 'message' ? 'your needs' : key);
      return value.validated;
    });

    const validatedForm = invalidFields.length === 0;

    const dataLayerInfo = {
      categoria: 'epica',
      tipo: 'contacto',
      status: validatedForm ? 'Completado' : 'No Completado',
    };

    if (!validatedForm) dataLayerInfo.mensaje = `Faltan campos por completar: ${invalidFields.join(', ')}`;

    window.dataLayer = window.dataLayer || [];
    window.dataLayer.push({
      event: 'ev_form',
      data: dataLayerInfo,
    });

    if (validatedInputs.length === 5) {
      const data = Object.fromEntries(new FormData(e.target).entries());
      mutate(data);
    }
  };
  const moveCircle = useCallback(() => {
    try {
      setTimeout(() => {
        const label = [...document.querySelectorAll(`${clase} form label`)].find(
          (label) => label.htmlFor === formSelectedLabel
        );
        if (!label) return;
        const formGroup = label.parentElement;
        const circleProps = {
          top: `${(formGroup.offsetTop + label.clientHeight / 4).toFixed(2)}px`,
          left: `${(formGroup.offsetLeft + label.clientWidth + 12).toFixed(2)}px`,
        };
        setCircleProperties(circleProps);
      }, 100);
    } catch (error) {
      console.log(error);
    }
  }, [formSelectedLabel]);

  useEffect(() => {
    moveCircle();
    window.addEventListener('resize', moveCircle);
    return window.removeEventListener('resize', moveCircle);
  });
  return (
    <form noValidate className='form' onSubmit={submitEventHandler} ref={formulario}>
      <div className='form__circle' ref={formCircle} style={circleProperties}></div>
      {formInputs.map((input, i) => (
        <InputForm key={i} inputProps={input.inputProps} label={input.label} />
      ))}
      <div className='form__group'>
        {isLoading && <PreloaderForm />}
        <button className={`form__submit-btn${isLoading ? ' form__submit-btn--disabled' : ''}`} disabled={isLoading}>
          <span className='form__submit-btn__text'>{!isLoading && 'Send'}</span>
          <span className='form__submit-btn__circle'>
            <img src={Arrow} alt='Click the white arrow to submit the form' />
          </span>
        </button>
      </div>
    </form>
  );
};
ContactForm.propTypes = {
  clase: PropTypes.string.isRequired,
};

export default ContactForm;
