import { memo } from 'react';
import { useSelector } from 'react-redux';
import { Container, Heading } from '../../components';
import { useInView } from 'react-intersection-observer';
import { isMobile } from 'react-device-detect';
import {
  WhatsEpicaVideo1,
  WhatsEpicaVideo2,
  WhatsEpicaImg1,
  WhatsEpicaImg2,
  WhatsEpicaImg1JPG,
  WhatsEpicaImg2JPG,
} from '../../assets';
import variables from '../../styles/variables.scss';
import './style.scss';

const WhatsEpica = memo(() => {
  const { webpSupport } = useSelector((state) => state.reducers);
  const { colorBlack, colorRed } = variables;
  const assetsMobile = [
    WhatsEpicaImg1,
    WhatsEpicaImg2,
    WhatsEpicaImg1JPG,
    WhatsEpicaImg2JPG,
  ];
  const assetsDesktop = [WhatsEpicaVideo1, WhatsEpicaVideo2];
  const { ref, inView } = useInView({
    threshold: 0.5,
    triggerOnce: true,
  });
  return (
    <section
      className={`whats-epica${!webpSupport ? ' whats-epica--nowebp' : ''}`}
      ref={ref}
    >
      <Container>
        <h2 style={{ display: 'none' }}>What’s Epica?</h2>
        <Heading
          css={{ color: colorBlack, backgroundColor: colorRed }}
          text='What’s Epica?'
        />
        <div className='content'>
          <Container inner>
            <div className='text-container'>
              <h3 style={{ display: 'none' }}>Epica is spanish for epic.</h3>
              <h3 className='subTitle'>
                <strong>Epica</strong> is spanish for{' '}
                <strong className='black-word'>epic.</strong>
              </h3>
              <p className='text-container__paragraph'>
                Driven by digital, technology, and innovation, we strive and
                aspire to inspire epic content experiences that revolutionize
                businesses forward.
              </p>
              <p className='text-container__paragraph'>
                As an international team of talents with extensive expertise in
                digital marketing, social media, creativity, and design, we
                consistently deliver results.
              </p>
              <p className='text-container__paragraph'>
                As part of the <span>UO Solutions Group</span>, we work
                alongside the most relevant digital partners.
              </p>
              <hr />
            </div>
          </Container>
        </div>
      </Container>
      <div className='whats-epica__videos-wrapper'>
        {assetsDesktop.map((video, i) => (
          <div
            className={`whats-epica__video-container${
              i === 1 ? ' whats-epica__video-container--2' : ''
            } ${inView ? ' whats-epica__video-container--active' : ''}`}
            key={i}
          >
            {inView && (
              <>
                {isMobile ? (
                  <img
                    src={assetsMobile[webpSupport ? i : i + 2]}
                    className='whats-epica__video'
                    alt="What's Epica"
                  />
                ) : (
                  <video
                    autoPlay
                    playsInline
                    muted
                    loop
                    src={video}
                    className='whats-epica__video'
                    poster={assetsMobile[webpSupport ? i : i + 2]}
                  />
                )}
              </>
            )}
          </div>
        ))}
      </div>
    </section>
  );
});

export default WhatsEpica;
