import { memo } from 'react';
import { useSelector } from 'react-redux';
import {
  Container,
  Heading,
  InfiniteBrandCarousel,
  ScrollTopBtn,
} from '../../components';
import { useMediaQuery } from '../../helpers/hooks';
import { logosWhoWeTrust, logosThirdRow, logosFourthRow } from './data';
import variables from '../../styles/variables.scss';
import './style.scss';

const { colorBlue, colorBlack } = variables;

const TrustedPartners = memo(() => {
  const { webpSupport } = useSelector((state) => state.reducers);
  const breakpointLg = useMediaQuery('lg');
  return (
    <section className='trusted-partners'>
      {breakpointLg && <ScrollTopBtn variant='dark' position='bottom' />}
      <Container>
        <Heading
          css={{ color: colorBlack, backgroundColor: colorBlue }}
          text='Trust us'
        />
      </Container>

      <div className='trusted-partners__container'>
        <div className='logos-container'>
          <Container inner>
            <div className='color-logos-container'>
              {!breakpointLg ? (
                <>
                  {['normal', 'reverse'].map((d, i) => (
                    <InfiniteBrandCarousel
                      key={i}
                      logos={
                        i === 0
                          ? logosThirdRow(webpSupport)
                          : logosFourthRow(webpSupport)
                      }
                      direction={d}
                    />
                  ))}
                </>
              ) : (
                <>
                  {[
                    logosThirdRow(webpSupport),
                    logosFourthRow(webpSupport),
                  ].map((logos, i) => (
                    <ul
                      className='color-logos-container__list color-logos-container__list--trust-us'
                      key={i}
                    >
                      {logos.map((logo, index) => (
                        <li key={index}>
                          <img
                            src={logo.src}
                            alt={logo.alt}
                            className={`infinite-brand__logo-img`}
                            data-brand={logo.alt.toLowerCase()}
                          />
                        </li>
                      ))}
                    </ul>
                  ))}
                </>
              )}
            </div>
          </Container>
          <Container>
            <Heading
              css={{ color: colorBlack, backgroundColor: colorBlue }}
              text='Who we trust'
            />
          </Container>
          <Container inner>
            <div className='color-logos-container'>
              {!breakpointLg ? (
                <InfiniteBrandCarousel
                  logos={logosWhoWeTrust(webpSupport)}
                  direction='normal'
                  clase='infinite-brand__logo-img--who-we-trust'
                />
              ) : (
                <ul className='color-logos-container__list color-logos-container__list--who-we-trust'>
                  {logosWhoWeTrust(webpSupport).map((logo, i) => (
                    <li key={i}>
                      <img
                        src={logo.src}
                        alt={logo.alt}
                        className={`infinite-brand__logo-img`}
                        data-brand={logo.alt.toLowerCase()}
                      />
                    </li>
                  ))}
                </ul>
              )}
            </div>
          </Container>
        </div>
      </div>
    </section>
  );
});

export default TrustedPartners;
