import {
  LogoAmazon,
  LogoAudi,
  LogoAvianca,
  LogoBigcommerce,
  LogoFacebook,
  LogoGatorade,
  LogoGoogle,
  LogoGooglePartners,
  LogoIBM,
  LogoJeep,
  LogoKFC,
  LogoKitkat,
  LogoLg,
  LogoMcdonalds,
  LogoMagento,
  LogoNissan,
  LogoPepsi,
  LogoSamsung,
  LogoShopify,
  LogoVtex,
  LogoWesternUnion,
  LogoAmazonPNG,
  LogoAudiPNG,
  LogoAviancaPNG,
  LogoBigcommercePNG,
  LogoFacebookPNG,
  LogoGatoradePNG,
  LogoGooglePNG,
  LogoGooglePartnersPNG,
  LogoIBMPNG,
  LogoJeepPNG,
  LogoKFCPNG,
  LogoKitkatPNG,
  LogoLgPNG,
  LogoMcdonaldsPNG,
  LogoMagentoPNG,
  LogoNissanPNG,
  LogoPepsiPNG,
  LogoSamsungPNG,
  LogoShopifyPNG,
  LogoVtexPNG,
  LogoWesternUnionPNG,
} from '../../assets';

const logosWhoWeTrust = (webpSupport) => [
  { src: webpSupport ? LogoMagento : LogoMagentoPNG, alt: 'Magento logotype' },
  {
    src: webpSupport ? LogoFacebook : LogoFacebookPNG,
    alt: 'Facebook Marketing Partner logotype',
  },
  {
    src: webpSupport ? LogoGooglePartners : LogoGooglePartnersPNG,
    alt: 'Google Partners logotype',
  },
  {
    src: webpSupport ? LogoBigcommerce : LogoBigcommercePNG,
    alt: 'BigCommerce logotype',
  },
  { src: webpSupport ? LogoShopify : LogoShopifyPNG, alt: 'Shopify logotype' },
  { src: webpSupport ? LogoVtex : LogoVtexPNG, alt: 'VTEX logotype' },
  {
    src: webpSupport ? LogoAmazon : LogoAmazonPNG,
    alt: 'Amazon Web Services logotype',
  },
];

const logosThirdRow = (webpSupport) => [
  { src: webpSupport ? LogoGoogle : LogoGooglePNG, alt: 'Google logotype' },
  { src: webpSupport ? LogoPepsi : LogoPepsiPNG, alt: 'Pepsi logotype' },
  {
    src: webpSupport ? LogoMcdonalds : LogoMcdonaldsPNG,
    alt: "McDonald's logotype",
  },
  { src: webpSupport ? LogoNissan : LogoNissanPNG, alt: 'Nissan logotype' },
  { src: webpSupport ? LogoKitkat : LogoKitkatPNG, alt: 'Kit Kat logotype' },
  { src: webpSupport ? LogoSamsung : LogoSamsungPNG, alt: 'Samsung logotype' },
  { src: webpSupport ? LogoKFC : LogoKFCPNG, alt: 'KFC logotype' },
];
const logosFourthRow = (webpSupport) => [
  {
    src: webpSupport ? LogoWesternUnion : LogoWesternUnionPNG,
    alt: 'Western Union logotype',
  },
  { src: webpSupport ? LogoIBM : LogoIBMPNG, alt: 'IBM logotype' },
  { src: webpSupport ? LogoLg : LogoLgPNG, alt: 'LG logotype' },
  { src: webpSupport ? LogoAudi : LogoAudiPNG, alt: 'Audi logotype' },
  { src: webpSupport ? LogoAvianca : LogoAviancaPNG, alt: 'Avianca logotype' },
  {
    src: webpSupport ? LogoGatorade : LogoGatoradePNG,
    alt: 'Gatorade logotype',
  },
  { src: webpSupport ? LogoJeep : LogoJeepPNG, alt: 'Jeep logotype' },
];

export { logosWhoWeTrust, logosThirdRow, logosFourthRow };
