import { useEffect, useRef, createRef, memo, Fragment } from 'react';
import { useSelector } from 'react-redux';
import gsap from 'gsap';
import { ScrollTrigger } from 'gsap/ScrollTrigger';
import { useMediaQuery } from '../../helpers/hooks.js';
import { useInView } from 'react-intersection-observer';
import { Container, Heading, InfiniteMarquee } from '../../components';
import {
  VideoBrettOppenheim,
  VideoCyberMonday,
  VideoDavinciKids,
  VideoFoolProofReading,
  VideoPepsiNickyJam,
  VideoPostFiltroInstagram,
  VideoQueeraf,
  VideoQuore,
  VideoQuorePride,
  VideoSpiritDay,
  PosterBrettOppenheim,
  PosterCyberMonday,
  PosterDavinciKids,
  PosterFoolProofReading,
  PosterPepsiNickyJam,
  PosterPostFiltroInstagram,
  PosterQueeraf,
  PosterQuore,
  PosterQuorePride,
  PosterSpiritDay,
  PosterBrettOppenheimJPG,
  PosterCyberMondayJPG,
  PosterDavinciKidsJPG,
  PosterFoolProofReadingJPG,
  PosterPepsiNickyJamJPG,
  PosterPostFiltroInstagramJPG,
  PosterQueerafJPG,
  PosterQuoreJPG,
  PosterQuorePrideJPG,
  PosterSpiritDayJPG,
} from '../../assets';
import variables from '../../styles/variables.scss';
import './style.scss';

gsap.registerPlugin(ScrollTrigger);

const SuccessStories = memo(() => {
  const { webpSupport } = useSelector((state) => state.reducers);
  const breakpointLg = useMediaQuery('lg');
  const { colorWhite, colorOrange1 } = variables;
  const refs = useRef([...Array(4)].map((_) => createRef(null)));
  const { ref, inView } = useInView({
    threshold: 0.25,
    triggerOnce: true,
  });
  const [colLeft, colCenter, colRight, triggerEl] = refs.current;
  const columns = [
    {
      clase: 'left',
      ref: colLeft,
      videos: [
        {
          video: VideoBrettOppenheim,
          poster: webpSupport ? PosterBrettOppenheim : PosterBrettOppenheimJPG,
        },
        {
          video: VideoPepsiNickyJam,
          poster: webpSupport ? PosterPepsiNickyJam : PosterPepsiNickyJamJPG,
          type: 'img',
          alt: 'Pepsi Nicky Jam banner',
        },
        {
          video: VideoCyberMonday,
          poster: webpSupport ? PosterCyberMonday : PosterCyberMondayJPG,
        },
      ],
    },
    {
      clase: 'center',
      ref: colCenter,
      videos: [
        {
          video: VideoQueeraf,
          poster: webpSupport ? PosterQueeraf : PosterQueerafJPG,
          type: 'img',
          alt: 'Publicity Queer AF banner',
        },
        {
          video: VideoPostFiltroInstagram,
          poster: webpSupport
            ? PosterPostFiltroInstagram
            : PosterPostFiltroInstagramJPG,
          type: 'img',
          alt: 'Instagram Post Filter Banner',
        },
        {
          video: VideoFoolProofReading,
          poster: webpSupport
            ? PosterFoolProofReading
            : PosterFoolProofReadingJPG,
          type: 'img',
          alt: 'Fool Proof Reading Banner App',
        },
        {
          video: VideoQuore,
          poster: webpSupport ? PosterQuore : PosterQuoreJPG,
        },
        {
          video: VideoQuorePride,
          poster: webpSupport ? PosterQuorePride : PosterQuorePrideJPG,
          type: 'img',
          alt: 'Quore "Happy Pride" Promo Banner',
        },
      ],
    },
    {
      clase: 'right',
      ref: colRight,
      videos: [
        {
          video: VideoDavinciKids,
          poster: webpSupport ? PosterDavinciKids : PosterDavinciKidsJPG,
          type: 'img',
          alt: 'Davinci Kids Promo Banner',
        },
        {
          video: VideoSpiritDay,
          poster: webpSupport ? PosterSpiritDay : PosterSpiritDayJPG,
          type: 'img',
          alt: 'Spirit Day LGBTQ+ More tolerance',
        },
        {
          video: VideoQueeraf,
          poster: webpSupport ? PosterQueeraf : PosterQueerafJPG,
          type: 'img',
          alt: 'Publicity Queer AF banner',
        },
      ],
    },
  ];

  useEffect(() => {
    const tl = gsap.timeline({
      scrollTrigger: {
        trigger: triggerEl.current,
        scrub: 2,
        start: breakpointLg ? 'top top' : null,
        end: breakpointLg ? 'bottom bottom' : null,
      },
    });
    tl.fromTo(colLeft.current, { y: '-7%' }, { y: '0%' }, 0);
    tl.fromTo(colCenter.current, { y: 0 }, { y: '-70%' }, 0);
    tl.fromTo(colRight.current, { y: '-15%' }, { y: '0%' }, 0);
  }, [breakpointLg]);

  return (
    <section
      className={`success-stories${
        !webpSupport ? ' success-stories--nowebp' : ''
      }`}
    >
      <Container>
        <h2 style={{ display: 'none' }}>Epically Creative Success Stories</h2>
        <Heading
          css={{ color: colorWhite, backgroundColor: colorOrange1 }}
          text='Epically Creative Success Stories'
        />
      </Container>
      <div className='success-stories__content' ref={ref}>
        <div
          className={`success-stories__content-wrapper${
            inView ? ' success-stories__content-wrapper--reveal' : ''
          }`}
          ref={triggerEl}
        >
          <div className='success-stories__marquee success-stories__marquee--top'>
            <InfiniteMarquee />
          </div>
          {columns.map((col, i) => (
            <div key={i} className={`success-stories__col-${col.clase}`}>
              <div
                className='success-stories__col-inside-wrapper'
                ref={col.ref}
              >
                {col.videos.map((videos, index) => (
                  <Fragment key={index}>
                    {videos.type ? (
                      <img
                        src={videos.poster}
                        className='success-stories__video'
                        alt={videos.alt}
                      />
                    ) : (
                      <video
                        key={index}
                        autoPlay
                        playsInline
                        muted
                        loop
                        poster={videos.poster}
                        src={videos.video}
                        className='success-stories__video'
                      />
                    )}
                  </Fragment>
                ))}
              </div>
            </div>
          ))}

          <div className='success-stories__marquee success-stories__marquee--bottom'>
            <InfiniteMarquee direction='reverse' />
          </div>
        </div>
      </div>
    </section>
  );
});

export default SuccessStories;
