import { useEffect, forwardRef, memo } from 'react';
import { useDispatch } from 'react-redux';
import { changeState } from '../../store/actions';
/* import gsap from "gsap"; */
import {
  Container,
  Heading,
  /* ServicesDesktop, */
  ServicesMobile,
  /* ServiceContextStore, */
} from '../../components';
import data from './data';
import variables from '../../styles/variables.scss';
import './style.scss';

const Services = memo(
  forwardRef(({}, ref) => {
    const dispatch = useDispatch();
    /* const getDevice = () => (window.innerWidth > 1199 ? "desktop" : "mobile"); */
    /* const [device, setDevice] = useState(getDevice()); */
    const getDynamicHeight = () => {
      try {
        setTimeout(() => {
          const array = [...document.querySelectorAll('.service__oval-inner')];
          dispatch(changeState('serviceColumnHeight', 'auto'));
          let maxHeight = 0;
          maxHeight = array
            .map((elHeight) => elHeight.clientHeight)
            .reduce((acc, val) => {
              if (acc > val) return acc;
              else return val;
            }, 0);
          dispatch(changeState('serviceColumnHeight', maxHeight + 'px'));
        }, 500);
      } catch (error) {
        console.dir(error);
      }
    };

    /*  const scrollDownMouse = useRef(null); */
    const { colorWhite, colorOrange1 } = variables;
    useEffect(() => {
      getDynamicHeight();
      /*  device === "mobile" &&
      ScrollTrigger.getAll().length > 0 &&
      ScrollTrigger.getAll()[0].kill(); */
      window.addEventListener('resize', () => {
        /*  setDevice((prev) => (prev = getDevice())); */
        getDynamicHeight();
      });
      /* gsap.to(scrollDownMouse.current, { alpha: 1, duration: 0.5, delay: 2 }); */
      return () => window.removeEventListener('resize', getDynamicHeight);
    }, []);
    return (
      <section className='services'>
        <Container>
          <h2 style={{ display: 'none' }}>Our Epic Services :)</h2>
          <Heading css={{ color: colorWhite, backgroundColor: colorOrange1 }} text='Our Epic Services :)' />

          <p className='services__description'>
            Our experts translate relevant social conversations and trends into resonating and highly-engaging digital
            strategies.
          </p>
          {/* <ServiceContextStore> */}
          {/* </ServiceContextStore> */}

          <div className='services__content-wrapper'>
            {/*  {device === "desktop" ? (
                <ServicesDesktop data={data} />
              ) : ( */}
            <ServicesMobile data={data} />
            {/* )} */}
          </div>
        </Container>
      </section>
    );
  })
);

export default Services;
