/* eslint-disable import/no-anonymous-default-export */
export default (gsap, servicesContainer) => {
  const circles = gsap.utils.toArray(".services__circle");
  const headlines = gsap.utils.toArray(".services__circle h4");
  const singleServices = gsap.utils.toArray(".services__single-service");
  const serviceOvalInner = gsap.utils.toArray(".service__oval-inner");
  const ovals = gsap.utils.toArray(".services__oval");

  const tl = gsap.timeline({
    scrollTrigger: {
      trigger: ".services",
      scroller: ".e-app",
      start: "-200 top",
    },
  });
  tl.from(circles, {
    x: gsap.utils.wrap([0, "-160%", "-200%"]),
    scale: 0,
    duration: 0.6,
    stagger: 0.45,
    ease: "linear",
  })
    .from(
      headlines,
      {
        alpha: 0,
        duration: 0.4,
        ease: "linear",
        stagger: 0.4,
      },
      "-=1"
    )
    .to(servicesContainer.current, { filter: "none" });
  const tl2 = gsap.timeline({
    scrollTrigger: {
      trigger: circles,
      scroller: ".e-app",
      start: "top top",
    },
  });
  tl2
    .from(ovals, {
      y: "-30%",
      scale: 0,
      duration: 0.5,
      transformOrigin: "center top",
      stagger: 0.2,
    })
    .to(singleServices, { filter: "none" })
    .from(
      serviceOvalInner,
      {
        alpha: 0,
        duration: 0.4,
        ease: "linear",
        stagger: 0.2,
      },
      "-=1"
    );
};
