import { useRef, createRef, useEffect } from 'react';
import { useSelector, useDispatch } from 'react-redux';
import { changeState } from '../../store/actions';
import gsap from 'gsap';
import { MainIntro, DiscoverEpica, Header, ScrollDownMouse, Preloader, MainLogo, Sphere } from '../../components';
import './style.scss';
import { bgAnimation } from './animations';

const Hero = () => {
  const { isIntroLoaded, isIntroEnded, webpSupport, heroBgColor, isIntroPlaying, isMainContentLoaded } = useSelector(
    (state) => state.reducers
  );
  const dispatch = useDispatch();
  const DOMElementRefs = useRef([...Array(5)].map((_) => createRef(null)));
  const [header, scrollDownMouse, discoverEpica, hero, sphere] = DOMElementRefs.current;

  useEffect(() => {
    bgAnimation(gsap, isIntroEnded, hero, sphere);
    isIntroLoaded &&
      gsap.to([header.current, scrollDownMouse.current, discoverEpica.current], {
        alpha: 1,
        delay: 4,
        duration: 1,
        onComplete: () => {
          !isIntroEnded && dispatch(changeState('isIntroEnded', true));
        },
      });
  }, [isIntroLoaded, isIntroEnded]);
  return (
    <section className={`hero${webpSupport ? '' : ' hero--nowebp'}${heroBgColor ? ' hero--bg-orange' : ''}`} ref={hero}>
      <h1 style={{ display: 'none' }}>We are Epica</h1>
      <h2 style={{ display: 'none' }}>A Miami-Based Creative Agency</h2>
      <MainIntro />
      <Header ref={header} />
      {!isIntroPlaying && <Preloader />}
      <Sphere ref={sphere} />
      <div className='hero__content'>
        {isIntroEnded && <MainLogo hero={hero} />}
        <DiscoverEpica ref={discoverEpica} />
        <ScrollDownMouse ref={scrollDownMouse} />
      </div>
    </section>
  );
};

export default Hero;
