export const bgAnimation = (gsap, isIntroEnded, hero, sphere) => {
  const bgTimeline = gsap.timeline({
    paused: true,
  });
  isIntroEnded && bgTimeline.resume();
  bgTimeline.to(sphere.current, { autoAlpha: 1, duration: 1 }).to(
    hero.current,
    {
      background: 'rgb(65,85,146)',
      duration: 0.5,
    },
    0
  );
};

export const svgAnimation = (
  gsap,
  weAre,
  epica,
  slogan,
  line,
  circle,
  hero
) => {
  let counter = 0;
  const bgColors = ['239,49,41', '249,174,43', '65,85,146'];
  const svgTimeline = gsap.timeline();
  gsap.set(epica.children, { y: '15%' });
  svgTimeline
    .to(weAre.children, {
      autoAlpha: 1,
      duration: 0.5,
      stagger: 0.05,
      ease: 'sine.out',
    })
    .to(
      epica.children,
      {
        autoAlpha: 1,
        y: '0%',
        duration: 1,
        stagger: 0.1,
        ease: 'elastic.out',
      },
      '-=.5'
    )
    .to(weAre.children, {
      fill: '#F87E12',
      duration: 1,
      ease: 'sine.out',
    })
    .to(
      slogan.children,
      {
        autoAlpha: 1,
        duration: 0.4,
        stagger: 0.015,
        ease: 'easeOut',
      },
      '-=.5'
    )
    .from(
      line,
      {
        scaleX: 0,
        transformOrigin: '50%',
        duration: 0.6,
        ease: 'sine.out',
      },
      '-=.7'
    );
  gsap.to(
    circle,
    {
      keyframes: {
        '0%': {
          yPercent: 0,
          scaleY: 1,
          scaleX: 1,
          autoAlpha: 1,
          ease: 'sine.out',
        },
        '7%': { yPercent: 5, scaleY: 0.9, scaleX: 1.1, ease: 'sine.in' },
        '25%': { yPercent: 100, scaleY: 1.15, scaleX: 0.9, ease: 'sine.in' },
        '50%': { yPercent: 315, scaleY: 1, scaleX: 1, ease: 'none' },
        '60%': {
          scaleY: 0.4,
          scaleX: 1.6,
          ease: 'none',
          onComplete: () => {
            gsap.set(
              hero.current,
              { background: `rgb(${bgColors[counter]})` },
              '+=1'
            );
            counter === 2 ? (counter = 0) : counter++;
          },
        },
        '65%': { yPercent: 315, scaleY: 1, scaleX: 1, ease: 'sine.out' },
        '100%': { yPercent: 0, scaleY: 1, scaleX: 1, ease: 'out' },
      },
      duration: 1,
      transformOrigin: 'center bottom',
      repeat: -1,
    },
    4
  );
};
