import { memo } from 'react';
import { ContactForm, Container, Heading } from '../../components';
import variables from '../../styles/variables.scss';
import './style.scss';

const ElevateYourBrand = memo(() => {
  const { colorWhite, colorOrange1 } = variables;
  return (
    <section className='section-contact-form'>
      <Container>
        <h2 style={{ display: 'none' }}>It’s time to elevate your brand</h2>
        <Heading
          css={{ color: colorWhite, backgroundColor: colorOrange1 }}
          text='It’s time to elevate your brand'
        />
        <Container inner>
          <div className='subtitle'>
            <p>
              We’d love to hear about you and start an epic journey of growth
              together.
              <strong> Are you in?</strong>
            </p>
          </div>
        </Container>
      </Container>
      <Container inner>
        <div className='form-container active'>
          <ContactForm clase='.form-container' />
        </div>
      </Container>
    </section>
  );
});

export default ElevateYourBrand;
